// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Connection draining allows open connections to a backend server to be active for a specified time after the backend server got removed from the configuration. </summary>
    public partial class ApplicationGatewayConnectionDraining
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ApplicationGatewayConnectionDraining"/>. </summary>
        /// <param name="enabled"> Whether connection draining is enabled or not. </param>
        /// <param name="drainTimeoutInSeconds"> The number of seconds connection draining is active. Acceptable values are from 1 second to 3600 seconds. </param>
        public ApplicationGatewayConnectionDraining(bool enabled, int drainTimeoutInSeconds)
        {
            Enabled = enabled;
            DrainTimeoutInSeconds = drainTimeoutInSeconds;
        }

        /// <summary> Initializes a new instance of <see cref="ApplicationGatewayConnectionDraining"/>. </summary>
        /// <param name="enabled"> Whether connection draining is enabled or not. </param>
        /// <param name="drainTimeoutInSeconds"> The number of seconds connection draining is active. Acceptable values are from 1 second to 3600 seconds. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ApplicationGatewayConnectionDraining(bool enabled, int drainTimeoutInSeconds, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Enabled = enabled;
            DrainTimeoutInSeconds = drainTimeoutInSeconds;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ApplicationGatewayConnectionDraining"/> for deserialization. </summary>
        internal ApplicationGatewayConnectionDraining()
        {
        }

        /// <summary> Whether connection draining is enabled or not. </summary>
        public bool Enabled { get; set; }
        /// <summary> The number of seconds connection draining is active. Acceptable values are from 1 second to 3600 seconds. </summary>
        public int DrainTimeoutInSeconds { get; set; }
    }
}
