// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Response for ApplicationGatewayBackendHealth API service call. </summary>
    public partial class ApplicationGatewayBackendHealth
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ApplicationGatewayBackendHealth"/>. </summary>
        internal ApplicationGatewayBackendHealth()
        {
            BackendAddressPools = new ChangeTrackingList<ApplicationGatewayBackendHealthPool>();
        }

        /// <summary> Initializes a new instance of <see cref="ApplicationGatewayBackendHealth"/>. </summary>
        /// <param name="backendAddressPools"> A list of ApplicationGatewayBackendHealthPool resources. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ApplicationGatewayBackendHealth(IReadOnlyList<ApplicationGatewayBackendHealthPool> backendAddressPools, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            BackendAddressPools = backendAddressPools;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> A list of ApplicationGatewayBackendHealthPool resources. </summary>
        public IReadOnlyList<ApplicationGatewayBackendHealthPool> BackendAddressPools { get; }
    }
}
