// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Backend Address Pool of an application gateway. </summary>
    public partial class ApplicationGatewayBackendAddressPool : NetworkResourceData
    {
        /// <summary> Initializes a new instance of <see cref="ApplicationGatewayBackendAddressPool"/>. </summary>
        public ApplicationGatewayBackendAddressPool()
        {
            BackendIPConfigurations = new ChangeTrackingList<NetworkInterfaceIPConfigurationData>();
            BackendAddresses = new ChangeTrackingList<ApplicationGatewayBackendAddress>();
        }

        /// <summary> Initializes a new instance of <see cref="ApplicationGatewayBackendAddressPool"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="backendIPConfigurations"> Collection of references to IPs defined in network interfaces. </param>
        /// <param name="backendAddresses"> Backend addresses. </param>
        /// <param name="provisioningState"> The provisioning state of the backend address pool resource. </param>
        internal ApplicationGatewayBackendAddressPool(ResourceIdentifier id, string name, ResourceType? resourceType, IDictionary<string, BinaryData> serializedAdditionalRawData, ETag? etag, IReadOnlyList<NetworkInterfaceIPConfigurationData> backendIPConfigurations, IList<ApplicationGatewayBackendAddress> backendAddresses, NetworkProvisioningState? provisioningState) : base(id, name, resourceType, serializedAdditionalRawData)
        {
            ETag = etag;
            BackendIPConfigurations = backendIPConfigurations;
            BackendAddresses = backendAddresses;
            ProvisioningState = provisioningState;
        }

        /// <summary> A unique read-only string that changes whenever the resource is updated. </summary>
        public ETag? ETag { get; }
        /// <summary> Collection of references to IPs defined in network interfaces. </summary>
        public IReadOnlyList<NetworkInterfaceIPConfigurationData> BackendIPConfigurations { get; }
        /// <summary> Backend addresses. </summary>
        public IList<ApplicationGatewayBackendAddress> BackendAddresses { get; }
        /// <summary> The provisioning state of the backend address pool resource. </summary>
        public NetworkProvisioningState? ProvisioningState { get; }
    }
}
