// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Active connectivity configuration. </summary>
    public partial class ActiveConnectivityConfiguration : EffectiveConnectivityConfiguration
    {
        /// <summary> Initializes a new instance of <see cref="ActiveConnectivityConfiguration"/>. </summary>
        internal ActiveConnectivityConfiguration()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ActiveConnectivityConfiguration"/>. </summary>
        /// <param name="id"> Connectivity configuration ID. </param>
        /// <param name="configurationGroups"> Effective configuration groups. </param>
        /// <param name="description"> A description of the connectivity configuration. </param>
        /// <param name="connectivityTopology"> Connectivity topology type. </param>
        /// <param name="hubs"> List of hubItems. </param>
        /// <param name="isGlobal"> Flag if global mesh is supported. </param>
        /// <param name="appliesToGroups"> Groups for configuration. </param>
        /// <param name="provisioningState"> The provisioning state of the connectivity configuration resource. </param>
        /// <param name="deleteExistingPeering"> Flag if need to remove current existing peerings. </param>
        /// <param name="resourceGuid"> Unique identifier for this resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="committedOn"> Deployment time string. </param>
        /// <param name="region"> Deployment region. </param>
        internal ActiveConnectivityConfiguration(string id, IReadOnlyList<NetworkConfigurationGroup> configurationGroups, string description, ConnectivityTopology? connectivityTopology, IReadOnlyList<ConnectivityHub> hubs, GlobalMeshSupportFlag? isGlobal, IReadOnlyList<ConnectivityGroupItem> appliesToGroups, NetworkProvisioningState? provisioningState, DeleteExistingPeering? deleteExistingPeering, Guid? resourceGuid, IDictionary<string, BinaryData> serializedAdditionalRawData, DateTimeOffset? committedOn, AzureLocation? region) : base(id, configurationGroups, description, connectivityTopology, hubs, isGlobal, appliesToGroups, provisioningState, deleteExistingPeering, resourceGuid, serializedAdditionalRawData)
        {
            CommittedOn = committedOn;
            Region = region;
        }

        /// <summary> Deployment time string. </summary>
        public DateTimeOffset? CommittedOn { get; }
        /// <summary> Deployment region. </summary>
        public AzureLocation? Region { get; }
    }
}
