// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Network
{
    internal class VpnServerConfigurationPolicyGroupOperationSource : IOperationSource<VpnServerConfigurationPolicyGroupResource>
    {
        private readonly ArmClient _client;

        internal VpnServerConfigurationPolicyGroupOperationSource(ArmClient client)
        {
            _client = client;
        }

        VpnServerConfigurationPolicyGroupResource IOperationSource<VpnServerConfigurationPolicyGroupResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = VpnServerConfigurationPolicyGroupData.DeserializeVpnServerConfigurationPolicyGroupData(document.RootElement);
            return new VpnServerConfigurationPolicyGroupResource(_client, data);
        }

        async ValueTask<VpnServerConfigurationPolicyGroupResource> IOperationSource<VpnServerConfigurationPolicyGroupResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = VpnServerConfigurationPolicyGroupData.DeserializeVpnServerConfigurationPolicyGroupData(document.RootElement);
            return new VpnServerConfigurationPolicyGroupResource(_client, data);
        }
    }
}
