// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Network
{
    internal class VpnGatewayNatRuleOperationSource : IOperationSource<VpnGatewayNatRuleResource>
    {
        private readonly ArmClient _client;

        internal VpnGatewayNatRuleOperationSource(ArmClient client)
        {
            _client = client;
        }

        VpnGatewayNatRuleResource IOperationSource<VpnGatewayNatRuleResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = VpnGatewayNatRuleData.DeserializeVpnGatewayNatRuleData(document.RootElement);
            return new VpnGatewayNatRuleResource(_client, data);
        }

        async ValueTask<VpnGatewayNatRuleResource> IOperationSource<VpnGatewayNatRuleResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = VpnGatewayNatRuleData.DeserializeVpnGatewayNatRuleData(document.RootElement);
            return new VpnGatewayNatRuleResource(_client, data);
        }
    }
}
