// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Network
{
    internal class VpnConnectionOperationSource : IOperationSource<VpnConnectionResource>
    {
        private readonly ArmClient _client;

        internal VpnConnectionOperationSource(ArmClient client)
        {
            _client = client;
        }

        VpnConnectionResource IOperationSource<VpnConnectionResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = VpnConnectionData.DeserializeVpnConnectionData(document.RootElement);
            return new VpnConnectionResource(_client, data);
        }

        async ValueTask<VpnConnectionResource> IOperationSource<VpnConnectionResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = VpnConnectionData.DeserializeVpnConnectionData(document.RootElement);
            return new VpnConnectionResource(_client, data);
        }
    }
}
