// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Network
{
    internal class VirtualWanOperationSource : IOperationSource<VirtualWanResource>
    {
        private readonly ArmClient _client;

        internal VirtualWanOperationSource(ArmClient client)
        {
            _client = client;
        }

        VirtualWanResource IOperationSource<VirtualWanResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = VirtualWanData.DeserializeVirtualWanData(document.RootElement);
            return new VirtualWanResource(_client, data);
        }

        async ValueTask<VirtualWanResource> IOperationSource<VirtualWanResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = VirtualWanData.DeserializeVirtualWanData(document.RootElement);
            return new VirtualWanResource(_client, data);
        }
    }
}
