// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Network
{
    internal class VirtualNetworkPeeringOperationSource : IOperationSource<VirtualNetworkPeeringResource>
    {
        private readonly ArmClient _client;

        internal VirtualNetworkPeeringOperationSource(ArmClient client)
        {
            _client = client;
        }

        VirtualNetworkPeeringResource IOperationSource<VirtualNetworkPeeringResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = VirtualNetworkPeeringData.DeserializeVirtualNetworkPeeringData(document.RootElement);
            return new VirtualNetworkPeeringResource(_client, data);
        }

        async ValueTask<VirtualNetworkPeeringResource> IOperationSource<VirtualNetworkPeeringResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = VirtualNetworkPeeringData.DeserializeVirtualNetworkPeeringData(document.RootElement);
            return new VirtualNetworkPeeringResource(_client, data);
        }
    }
}
