// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Network
{
    internal class VirtualNetworkGatewayNatRuleOperationSource : IOperationSource<VirtualNetworkGatewayNatRuleResource>
    {
        private readonly ArmClient _client;

        internal VirtualNetworkGatewayNatRuleOperationSource(ArmClient client)
        {
            _client = client;
        }

        VirtualNetworkGatewayNatRuleResource IOperationSource<VirtualNetworkGatewayNatRuleResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = VirtualNetworkGatewayNatRuleData.DeserializeVirtualNetworkGatewayNatRuleData(document.RootElement);
            return new VirtualNetworkGatewayNatRuleResource(_client, data);
        }

        async ValueTask<VirtualNetworkGatewayNatRuleResource> IOperationSource<VirtualNetworkGatewayNatRuleResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = VirtualNetworkGatewayNatRuleData.DeserializeVirtualNetworkGatewayNatRuleData(document.RootElement);
            return new VirtualNetworkGatewayNatRuleResource(_client, data);
        }
    }
}
