// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Network
{
    internal class VirtualNetworkGatewayConnectionOperationSource : IOperationSource<VirtualNetworkGatewayConnectionResource>
    {
        private readonly ArmClient _client;

        internal VirtualNetworkGatewayConnectionOperationSource(ArmClient client)
        {
            _client = client;
        }

        VirtualNetworkGatewayConnectionResource IOperationSource<VirtualNetworkGatewayConnectionResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = VirtualNetworkGatewayConnectionData.DeserializeVirtualNetworkGatewayConnectionData(document.RootElement);
            return new VirtualNetworkGatewayConnectionResource(_client, data);
        }

        async ValueTask<VirtualNetworkGatewayConnectionResource> IOperationSource<VirtualNetworkGatewayConnectionResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = VirtualNetworkGatewayConnectionData.DeserializeVirtualNetworkGatewayConnectionData(document.RootElement);
            return new VirtualNetworkGatewayConnectionResource(_client, data);
        }
    }
}
