// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.ResourceManager.Network.Models;

namespace Azure.ResourceManager.Network
{
    internal class TroubleshootingResultOperationSource : IOperationSource<TroubleshootingResult>
    {
        TroubleshootingResult IOperationSource<TroubleshootingResult>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            return TroubleshootingResult.DeserializeTroubleshootingResult(document.RootElement);
        }

        async ValueTask<TroubleshootingResult> IOperationSource<TroubleshootingResult>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            return TroubleshootingResult.DeserializeTroubleshootingResult(document.RootElement);
        }
    }
}
