// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Network
{
    internal class ServiceEndpointPolicyOperationSource : IOperationSource<ServiceEndpointPolicyResource>
    {
        private readonly ArmClient _client;

        internal ServiceEndpointPolicyOperationSource(ArmClient client)
        {
            _client = client;
        }

        ServiceEndpointPolicyResource IOperationSource<ServiceEndpointPolicyResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ServiceEndpointPolicyData.DeserializeServiceEndpointPolicyData(document.RootElement);
            return new ServiceEndpointPolicyResource(_client, data);
        }

        async ValueTask<ServiceEndpointPolicyResource> IOperationSource<ServiceEndpointPolicyResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ServiceEndpointPolicyData.DeserializeServiceEndpointPolicyData(document.RootElement);
            return new ServiceEndpointPolicyResource(_client, data);
        }
    }
}
