// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Network
{
    internal class SecurityRuleOperationSource : IOperationSource<SecurityRuleResource>
    {
        private readonly ArmClient _client;

        internal SecurityRuleOperationSource(ArmClient client)
        {
            _client = client;
        }

        SecurityRuleResource IOperationSource<SecurityRuleResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = SecurityRuleData.DeserializeSecurityRuleData(document.RootElement);
            return new SecurityRuleResource(_client, data);
        }

        async ValueTask<SecurityRuleResource> IOperationSource<SecurityRuleResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = SecurityRuleData.DeserializeSecurityRuleData(document.RootElement);
            return new SecurityRuleResource(_client, data);
        }
    }
}
