// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Network
{
    internal class SecurityPartnerProviderOperationSource : IOperationSource<SecurityPartnerProviderResource>
    {
        private readonly ArmClient _client;

        internal SecurityPartnerProviderOperationSource(ArmClient client)
        {
            _client = client;
        }

        SecurityPartnerProviderResource IOperationSource<SecurityPartnerProviderResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = SecurityPartnerProviderData.DeserializeSecurityPartnerProviderData(document.RootElement);
            return new SecurityPartnerProviderResource(_client, data);
        }

        async ValueTask<SecurityPartnerProviderResource> IOperationSource<SecurityPartnerProviderResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = SecurityPartnerProviderData.DeserializeSecurityPartnerProviderData(document.RootElement);
            return new SecurityPartnerProviderResource(_client, data);
        }
    }
}
