// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Network
{
    internal class RoutingIntentOperationSource : IOperationSource<RoutingIntentResource>
    {
        private readonly ArmClient _client;

        internal RoutingIntentOperationSource(ArmClient client)
        {
            _client = client;
        }

        RoutingIntentResource IOperationSource<RoutingIntentResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = RoutingIntentData.DeserializeRoutingIntentData(document.RootElement);
            return new RoutingIntentResource(_client, data);
        }

        async ValueTask<RoutingIntentResource> IOperationSource<RoutingIntentResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = RoutingIntentData.DeserializeRoutingIntentData(document.RootElement);
            return new RoutingIntentResource(_client, data);
        }
    }
}
