// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Network
{
    internal class RouteMapOperationSource : IOperationSource<RouteMapResource>
    {
        private readonly ArmClient _client;

        internal RouteMapOperationSource(ArmClient client)
        {
            _client = client;
        }

        RouteMapResource IOperationSource<RouteMapResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = RouteMapData.DeserializeRouteMapData(document.RootElement);
            return new RouteMapResource(_client, data);
        }

        async ValueTask<RouteMapResource> IOperationSource<RouteMapResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = RouteMapData.DeserializeRouteMapData(document.RootElement);
            return new RouteMapResource(_client, data);
        }
    }
}
