// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Network
{
    internal class PublicIPPrefixOperationSource : IOperationSource<PublicIPPrefixResource>
    {
        private readonly ArmClient _client;

        internal PublicIPPrefixOperationSource(ArmClient client)
        {
            _client = client;
        }

        PublicIPPrefixResource IOperationSource<PublicIPPrefixResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = PublicIPPrefixData.DeserializePublicIPPrefixData(document.RootElement);
            return new PublicIPPrefixResource(_client, data);
        }

        async ValueTask<PublicIPPrefixResource> IOperationSource<PublicIPPrefixResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = PublicIPPrefixData.DeserializePublicIPPrefixData(document.RootElement);
            return new PublicIPPrefixResource(_client, data);
        }
    }
}
