// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.ResourceManager.Network.Models;

namespace Azure.ResourceManager.Network
{
    internal class PrivateLinkServiceVisibilityOperationSource : IOperationSource<PrivateLinkServiceVisibility>
    {
        PrivateLinkServiceVisibility IOperationSource<PrivateLinkServiceVisibility>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            return PrivateLinkServiceVisibility.DeserializePrivateLinkServiceVisibility(document.RootElement);
        }

        async ValueTask<PrivateLinkServiceVisibility> IOperationSource<PrivateLinkServiceVisibility>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            return PrivateLinkServiceVisibility.DeserializePrivateLinkServiceVisibility(document.RootElement);
        }
    }
}
