// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Network
{
    internal class PrivateEndpointOperationSource : IOperationSource<PrivateEndpointResource>
    {
        private readonly ArmClient _client;

        internal PrivateEndpointOperationSource(ArmClient client)
        {
            _client = client;
        }

        PrivateEndpointResource IOperationSource<PrivateEndpointResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = PrivateEndpointData.DeserializePrivateEndpointData(document.RootElement);
            return new PrivateEndpointResource(_client, data);
        }

        async ValueTask<PrivateEndpointResource> IOperationSource<PrivateEndpointResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = PrivateEndpointData.DeserializePrivateEndpointData(document.RootElement);
            return new PrivateEndpointResource(_client, data);
        }
    }
}
