// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Network
{
    internal class InboundSecurityRuleOperationSource : IOperationSource<InboundSecurityRuleResource>
    {
        private readonly ArmClient _client;

        internal InboundSecurityRuleOperationSource(ArmClient client)
        {
            _client = client;
        }

        InboundSecurityRuleResource IOperationSource<InboundSecurityRuleResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = InboundSecurityRuleData.DeserializeInboundSecurityRuleData(document.RootElement);
            return new InboundSecurityRuleResource(_client, data);
        }

        async ValueTask<InboundSecurityRuleResource> IOperationSource<InboundSecurityRuleResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = InboundSecurityRuleData.DeserializeInboundSecurityRuleData(document.RootElement);
            return new InboundSecurityRuleResource(_client, data);
        }
    }
}
