// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Network
{
    internal class InboundNatRuleOperationSource : IOperationSource<InboundNatRuleResource>
    {
        private readonly ArmClient _client;

        internal InboundNatRuleOperationSource(ArmClient client)
        {
            _client = client;
        }

        InboundNatRuleResource IOperationSource<InboundNatRuleResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = InboundNatRuleData.DeserializeInboundNatRuleData(document.RootElement);
            return new InboundNatRuleResource(_client, data);
        }

        async ValueTask<InboundNatRuleResource> IOperationSource<InboundNatRuleResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = InboundNatRuleData.DeserializeInboundNatRuleData(document.RootElement);
            return new InboundNatRuleResource(_client, data);
        }
    }
}
