// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Network
{
    internal class IPGroupOperationSource : IOperationSource<IPGroupResource>
    {
        private readonly ArmClient _client;

        internal IPGroupOperationSource(ArmClient client)
        {
            _client = client;
        }

        IPGroupResource IOperationSource<IPGroupResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = IPGroupData.DeserializeIPGroupData(document.RootElement);
            return new IPGroupResource(_client, data);
        }

        async ValueTask<IPGroupResource> IOperationSource<IPGroupResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = IPGroupData.DeserializeIPGroupData(document.RootElement);
            return new IPGroupResource(_client, data);
        }
    }
}
