// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.ResourceManager.Network.Models;

namespace Azure.ResourceManager.Network
{
    internal class IDictionaryOperationSource : IOperationSource<IDictionary<string, IList<PeerRoute>>>
    {
        IDictionary<string, IList<PeerRoute>> IOperationSource<IDictionary<string, IList<PeerRoute>>>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            Dictionary<string, IList<PeerRoute>> dictionary = new Dictionary<string, IList<PeerRoute>>();
            foreach (var property in document.RootElement.EnumerateObject())
            {
                if (property.Value.ValueKind == JsonValueKind.Null)
                {
                    dictionary.Add(property.Name, null);
                }
                else
                {
                    List<PeerRoute> array = new List<PeerRoute>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(PeerRoute.DeserializePeerRoute(item));
                    }
                    dictionary.Add(property.Name, array);
                }
            }
            return dictionary;
        }

        async ValueTask<IDictionary<string, IList<PeerRoute>>> IOperationSource<IDictionary<string, IList<PeerRoute>>>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            Dictionary<string, IList<PeerRoute>> dictionary = new Dictionary<string, IList<PeerRoute>>();
            foreach (var property in document.RootElement.EnumerateObject())
            {
                if (property.Value.ValueKind == JsonValueKind.Null)
                {
                    dictionary.Add(property.Name, null);
                }
                else
                {
                    List<PeerRoute> array = new List<PeerRoute>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(PeerRoute.DeserializePeerRoute(item));
                    }
                    dictionary.Add(property.Name, array);
                }
            }
            return dictionary;
        }
    }
}
