// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Network
{
    internal class HubIPConfigurationOperationSource : IOperationSource<HubIPConfigurationResource>
    {
        private readonly ArmClient _client;

        internal HubIPConfigurationOperationSource(ArmClient client)
        {
            _client = client;
        }

        HubIPConfigurationResource IOperationSource<HubIPConfigurationResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = HubIPConfigurationData.DeserializeHubIPConfigurationData(document.RootElement);
            return new HubIPConfigurationResource(_client, data);
        }

        async ValueTask<HubIPConfigurationResource> IOperationSource<HubIPConfigurationResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = HubIPConfigurationData.DeserializeHubIPConfigurationData(document.RootElement);
            return new HubIPConfigurationResource(_client, data);
        }
    }
}
