// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Network
{
    internal class FlowLogOperationSource : IOperationSource<FlowLogResource>
    {
        private readonly ArmClient _client;

        internal FlowLogOperationSource(ArmClient client)
        {
            _client = client;
        }

        FlowLogResource IOperationSource<FlowLogResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = FlowLogData.DeserializeFlowLogData(document.RootElement);
            return new FlowLogResource(_client, data);
        }

        async ValueTask<FlowLogResource> IOperationSource<FlowLogResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = FlowLogData.DeserializeFlowLogData(document.RootElement);
            return new FlowLogResource(_client, data);
        }
    }
}
