// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Network
{
    internal class ExpressRoutePortOperationSource : IOperationSource<ExpressRoutePortResource>
    {
        private readonly ArmClient _client;

        internal ExpressRoutePortOperationSource(ArmClient client)
        {
            _client = client;
        }

        ExpressRoutePortResource IOperationSource<ExpressRoutePortResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ExpressRoutePortData.DeserializeExpressRoutePortData(document.RootElement);
            return new ExpressRoutePortResource(_client, data);
        }

        async ValueTask<ExpressRoutePortResource> IOperationSource<ExpressRoutePortResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ExpressRoutePortData.DeserializeExpressRoutePortData(document.RootElement);
            return new ExpressRoutePortResource(_client, data);
        }
    }
}
