// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Network
{
    internal class ExpressRoutePortAuthorizationOperationSource : IOperationSource<ExpressRoutePortAuthorizationResource>
    {
        private readonly ArmClient _client;

        internal ExpressRoutePortAuthorizationOperationSource(ArmClient client)
        {
            _client = client;
        }

        ExpressRoutePortAuthorizationResource IOperationSource<ExpressRoutePortAuthorizationResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ExpressRoutePortAuthorizationData.DeserializeExpressRoutePortAuthorizationData(document.RootElement);
            return new ExpressRoutePortAuthorizationResource(_client, data);
        }

        async ValueTask<ExpressRoutePortAuthorizationResource> IOperationSource<ExpressRoutePortAuthorizationResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ExpressRoutePortAuthorizationData.DeserializeExpressRoutePortAuthorizationData(document.RootElement);
            return new ExpressRoutePortAuthorizationResource(_client, data);
        }
    }
}
