// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Network
{
    internal class ExpressRouteGatewayOperationSource : IOperationSource<ExpressRouteGatewayResource>
    {
        private readonly ArmClient _client;

        internal ExpressRouteGatewayOperationSource(ArmClient client)
        {
            _client = client;
        }

        ExpressRouteGatewayResource IOperationSource<ExpressRouteGatewayResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ExpressRouteGatewayData.DeserializeExpressRouteGatewayData(document.RootElement);
            return new ExpressRouteGatewayResource(_client, data);
        }

        async ValueTask<ExpressRouteGatewayResource> IOperationSource<ExpressRouteGatewayResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ExpressRouteGatewayData.DeserializeExpressRouteGatewayData(document.RootElement);
            return new ExpressRouteGatewayResource(_client, data);
        }
    }
}
