// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Network
{
    internal class ExpressRouteCircuitPeeringOperationSource : IOperationSource<ExpressRouteCircuitPeeringResource>
    {
        private readonly ArmClient _client;

        internal ExpressRouteCircuitPeeringOperationSource(ArmClient client)
        {
            _client = client;
        }

        ExpressRouteCircuitPeeringResource IOperationSource<ExpressRouteCircuitPeeringResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ExpressRouteCircuitPeeringData.DeserializeExpressRouteCircuitPeeringData(document.RootElement);
            return new ExpressRouteCircuitPeeringResource(_client, data);
        }

        async ValueTask<ExpressRouteCircuitPeeringResource> IOperationSource<ExpressRouteCircuitPeeringResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ExpressRouteCircuitPeeringData.DeserializeExpressRouteCircuitPeeringData(document.RootElement);
            return new ExpressRouteCircuitPeeringResource(_client, data);
        }
    }
}
