// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Network
{
    internal class ExpressRouteCircuitOperationSource : IOperationSource<ExpressRouteCircuitResource>
    {
        private readonly ArmClient _client;

        internal ExpressRouteCircuitOperationSource(ArmClient client)
        {
            _client = client;
        }

        ExpressRouteCircuitResource IOperationSource<ExpressRouteCircuitResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ExpressRouteCircuitData.DeserializeExpressRouteCircuitData(document.RootElement);
            return new ExpressRouteCircuitResource(_client, data);
        }

        async ValueTask<ExpressRouteCircuitResource> IOperationSource<ExpressRouteCircuitResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ExpressRouteCircuitData.DeserializeExpressRouteCircuitData(document.RootElement);
            return new ExpressRouteCircuitResource(_client, data);
        }
    }
}
