// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Network
{
    internal class ExpressRouteCircuitAuthorizationOperationSource : IOperationSource<ExpressRouteCircuitAuthorizationResource>
    {
        private readonly ArmClient _client;

        internal ExpressRouteCircuitAuthorizationOperationSource(ArmClient client)
        {
            _client = client;
        }

        ExpressRouteCircuitAuthorizationResource IOperationSource<ExpressRouteCircuitAuthorizationResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ExpressRouteCircuitAuthorizationData.DeserializeExpressRouteCircuitAuthorizationData(document.RootElement);
            return new ExpressRouteCircuitAuthorizationResource(_client, data);
        }

        async ValueTask<ExpressRouteCircuitAuthorizationResource> IOperationSource<ExpressRouteCircuitAuthorizationResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ExpressRouteCircuitAuthorizationData.DeserializeExpressRouteCircuitAuthorizationData(document.RootElement);
            return new ExpressRouteCircuitAuthorizationResource(_client, data);
        }
    }
}
