// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Network
{
    internal class DdosCustomPolicyOperationSource : IOperationSource<DdosCustomPolicyResource>
    {
        private readonly ArmClient _client;

        internal DdosCustomPolicyOperationSource(ArmClient client)
        {
            _client = client;
        }

        DdosCustomPolicyResource IOperationSource<DdosCustomPolicyResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DdosCustomPolicyData.DeserializeDdosCustomPolicyData(document.RootElement);
            return new DdosCustomPolicyResource(_client, data);
        }

        async ValueTask<DdosCustomPolicyResource> IOperationSource<DdosCustomPolicyResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DdosCustomPolicyData.DeserializeDdosCustomPolicyData(document.RootElement);
            return new DdosCustomPolicyResource(_client, data);
        }
    }
}
