// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Network
{
    internal class CustomIPPrefixOperationSource : IOperationSource<CustomIPPrefixResource>
    {
        private readonly ArmClient _client;

        internal CustomIPPrefixOperationSource(ArmClient client)
        {
            _client = client;
        }

        CustomIPPrefixResource IOperationSource<CustomIPPrefixResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = CustomIPPrefixData.DeserializeCustomIPPrefixData(document.RootElement);
            return new CustomIPPrefixResource(_client, data);
        }

        async ValueTask<CustomIPPrefixResource> IOperationSource<CustomIPPrefixResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = CustomIPPrefixData.DeserializeCustomIPPrefixData(document.RootElement);
            return new CustomIPPrefixResource(_client, data);
        }
    }
}
