// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.ResourceManager.Network.Models;

namespace Azure.ResourceManager.Network
{
    internal class ConnectionResetSharedKeyOperationSource : IOperationSource<ConnectionResetSharedKey>
    {
        ConnectionResetSharedKey IOperationSource<ConnectionResetSharedKey>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            return ConnectionResetSharedKey.DeserializeConnectionResetSharedKey(document.RootElement);
        }

        async ValueTask<ConnectionResetSharedKey> IOperationSource<ConnectionResetSharedKey>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            return ConnectionResetSharedKey.DeserializeConnectionResetSharedKey(document.RootElement);
        }
    }
}
