// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Network
{
    internal class ConnectionMonitorOperationSource : IOperationSource<ConnectionMonitorResource>
    {
        private readonly ArmClient _client;

        internal ConnectionMonitorOperationSource(ArmClient client)
        {
            _client = client;
        }

        ConnectionMonitorResource IOperationSource<ConnectionMonitorResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ConnectionMonitorData.DeserializeConnectionMonitorData(document.RootElement);
            return new ConnectionMonitorResource(_client, data);
        }

        async ValueTask<ConnectionMonitorResource> IOperationSource<ConnectionMonitorResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ConnectionMonitorData.DeserializeConnectionMonitorData(document.RootElement);
            return new ConnectionMonitorResource(_client, data);
        }
    }
}
