// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Network
{
    internal class BgpConnectionOperationSource : IOperationSource<BgpConnectionResource>
    {
        private readonly ArmClient _client;

        internal BgpConnectionOperationSource(ArmClient client)
        {
            _client = client;
        }

        BgpConnectionResource IOperationSource<BgpConnectionResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = BgpConnectionData.DeserializeBgpConnectionData(document.RootElement);
            return new BgpConnectionResource(_client, data);
        }

        async ValueTask<BgpConnectionResource> IOperationSource<BgpConnectionResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = BgpConnectionData.DeserializeBgpConnectionData(document.RootElement);
            return new BgpConnectionResource(_client, data);
        }
    }
}
