// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Network
{
    internal class BastionHostOperationSource : IOperationSource<BastionHostResource>
    {
        private readonly ArmClient _client;

        internal BastionHostOperationSource(ArmClient client)
        {
            _client = client;
        }

        BastionHostResource IOperationSource<BastionHostResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = BastionHostData.DeserializeBastionHostData(document.RootElement);
            return new BastionHostResource(_client, data);
        }

        async ValueTask<BastionHostResource> IOperationSource<BastionHostResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = BastionHostData.DeserializeBastionHostData(document.RootElement);
            return new BastionHostResource(_client, data);
        }
    }
}
