// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Network
{
    internal class BackendAddressPoolOperationSource : IOperationSource<BackendAddressPoolResource>
    {
        private readonly ArmClient _client;

        internal BackendAddressPoolOperationSource(ArmClient client)
        {
            _client = client;
        }

        BackendAddressPoolResource IOperationSource<BackendAddressPoolResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = BackendAddressPoolData.DeserializeBackendAddressPoolData(document.RootElement);
            return new BackendAddressPoolResource(_client, data);
        }

        async ValueTask<BackendAddressPoolResource> IOperationSource<BackendAddressPoolResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = BackendAddressPoolData.DeserializeBackendAddressPoolData(document.RootElement);
            return new BackendAddressPoolResource(_client, data);
        }
    }
}
