// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Network
{
    internal class ApplicationGatewayPrivateEndpointConnectionOperationSource : IOperationSource<ApplicationGatewayPrivateEndpointConnectionResource>
    {
        private readonly ArmClient _client;

        internal ApplicationGatewayPrivateEndpointConnectionOperationSource(ArmClient client)
        {
            _client = client;
        }

        ApplicationGatewayPrivateEndpointConnectionResource IOperationSource<ApplicationGatewayPrivateEndpointConnectionResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ApplicationGatewayPrivateEndpointConnectionData.DeserializeApplicationGatewayPrivateEndpointConnectionData(document.RootElement);
            return new ApplicationGatewayPrivateEndpointConnectionResource(_client, data);
        }

        async ValueTask<ApplicationGatewayPrivateEndpointConnectionResource> IOperationSource<ApplicationGatewayPrivateEndpointConnectionResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ApplicationGatewayPrivateEndpointConnectionData.DeserializeApplicationGatewayPrivateEndpointConnectionData(document.RootElement);
            return new ApplicationGatewayPrivateEndpointConnectionResource(_client, data);
        }
    }
}
