// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.Network.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableNetworkArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableNetworkArmClient"/> class for mocking. </summary>
        protected MockableNetworkArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableNetworkArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableNetworkArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableNetworkArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing an <see cref="ApplicationGatewayResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ApplicationGatewayResource.CreateResourceIdentifier" /> to create an <see cref="ApplicationGatewayResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ApplicationGatewayResource"/> object. </returns>
        public virtual ApplicationGatewayResource GetApplicationGatewayResource(ResourceIdentifier id)
        {
            ApplicationGatewayResource.ValidateResourceId(id);
            return new ApplicationGatewayResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ApplicationGatewayPrivateEndpointConnectionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ApplicationGatewayPrivateEndpointConnectionResource.CreateResourceIdentifier" /> to create an <see cref="ApplicationGatewayPrivateEndpointConnectionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ApplicationGatewayPrivateEndpointConnectionResource"/> object. </returns>
        public virtual ApplicationGatewayPrivateEndpointConnectionResource GetApplicationGatewayPrivateEndpointConnectionResource(ResourceIdentifier id)
        {
            ApplicationGatewayPrivateEndpointConnectionResource.ValidateResourceId(id);
            return new ApplicationGatewayPrivateEndpointConnectionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ApplicationGatewayWafDynamicManifestResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ApplicationGatewayWafDynamicManifestResource.CreateResourceIdentifier" /> to create an <see cref="ApplicationGatewayWafDynamicManifestResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ApplicationGatewayWafDynamicManifestResource"/> object. </returns>
        public virtual ApplicationGatewayWafDynamicManifestResource GetApplicationGatewayWafDynamicManifestResource(ResourceIdentifier id)
        {
            ApplicationGatewayWafDynamicManifestResource.ValidateResourceId(id);
            return new ApplicationGatewayWafDynamicManifestResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ApplicationSecurityGroupResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ApplicationSecurityGroupResource.CreateResourceIdentifier" /> to create an <see cref="ApplicationSecurityGroupResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ApplicationSecurityGroupResource"/> object. </returns>
        public virtual ApplicationSecurityGroupResource GetApplicationSecurityGroupResource(ResourceIdentifier id)
        {
            ApplicationSecurityGroupResource.ValidateResourceId(id);
            return new ApplicationSecurityGroupResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="AzureFirewallResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="AzureFirewallResource.CreateResourceIdentifier" /> to create an <see cref="AzureFirewallResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="AzureFirewallResource"/> object. </returns>
        public virtual AzureFirewallResource GetAzureFirewallResource(ResourceIdentifier id)
        {
            AzureFirewallResource.ValidateResourceId(id);
            return new AzureFirewallResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="AzureWebCategoryResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="AzureWebCategoryResource.CreateResourceIdentifier" /> to create an <see cref="AzureWebCategoryResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="AzureWebCategoryResource"/> object. </returns>
        public virtual AzureWebCategoryResource GetAzureWebCategoryResource(ResourceIdentifier id)
        {
            AzureWebCategoryResource.ValidateResourceId(id);
            return new AzureWebCategoryResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="BastionHostResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="BastionHostResource.CreateResourceIdentifier" /> to create a <see cref="BastionHostResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="BastionHostResource"/> object. </returns>
        public virtual BastionHostResource GetBastionHostResource(ResourceIdentifier id)
        {
            BastionHostResource.ValidateResourceId(id);
            return new BastionHostResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ExpressRouteProviderPortResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ExpressRouteProviderPortResource.CreateResourceIdentifier" /> to create an <see cref="ExpressRouteProviderPortResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ExpressRouteProviderPortResource"/> object. </returns>
        public virtual ExpressRouteProviderPortResource GetExpressRouteProviderPortResource(ResourceIdentifier id)
        {
            ExpressRouteProviderPortResource.ValidateResourceId(id);
            return new ExpressRouteProviderPortResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="CloudServiceSwapResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="CloudServiceSwapResource.CreateResourceIdentifier" /> to create a <see cref="CloudServiceSwapResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="CloudServiceSwapResource"/> object. </returns>
        public virtual CloudServiceSwapResource GetCloudServiceSwapResource(ResourceIdentifier id)
        {
            CloudServiceSwapResource.ValidateResourceId(id);
            return new CloudServiceSwapResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="CustomIPPrefixResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="CustomIPPrefixResource.CreateResourceIdentifier" /> to create a <see cref="CustomIPPrefixResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="CustomIPPrefixResource"/> object. </returns>
        public virtual CustomIPPrefixResource GetCustomIPPrefixResource(ResourceIdentifier id)
        {
            CustomIPPrefixResource.ValidateResourceId(id);
            return new CustomIPPrefixResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DdosCustomPolicyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DdosCustomPolicyResource.CreateResourceIdentifier" /> to create a <see cref="DdosCustomPolicyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DdosCustomPolicyResource"/> object. </returns>
        public virtual DdosCustomPolicyResource GetDdosCustomPolicyResource(ResourceIdentifier id)
        {
            DdosCustomPolicyResource.ValidateResourceId(id);
            return new DdosCustomPolicyResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DdosProtectionPlanResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DdosProtectionPlanResource.CreateResourceIdentifier" /> to create a <see cref="DdosProtectionPlanResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DdosProtectionPlanResource"/> object. </returns>
        public virtual DdosProtectionPlanResource GetDdosProtectionPlanResource(ResourceIdentifier id)
        {
            DdosProtectionPlanResource.ValidateResourceId(id);
            return new DdosProtectionPlanResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DscpConfigurationResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DscpConfigurationResource.CreateResourceIdentifier" /> to create a <see cref="DscpConfigurationResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DscpConfigurationResource"/> object. </returns>
        public virtual DscpConfigurationResource GetDscpConfigurationResource(ResourceIdentifier id)
        {
            DscpConfigurationResource.ValidateResourceId(id);
            return new DscpConfigurationResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ExpressRouteCircuitAuthorizationResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ExpressRouteCircuitAuthorizationResource.CreateResourceIdentifier" /> to create an <see cref="ExpressRouteCircuitAuthorizationResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ExpressRouteCircuitAuthorizationResource"/> object. </returns>
        public virtual ExpressRouteCircuitAuthorizationResource GetExpressRouteCircuitAuthorizationResource(ResourceIdentifier id)
        {
            ExpressRouteCircuitAuthorizationResource.ValidateResourceId(id);
            return new ExpressRouteCircuitAuthorizationResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ExpressRouteCircuitPeeringResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ExpressRouteCircuitPeeringResource.CreateResourceIdentifier" /> to create an <see cref="ExpressRouteCircuitPeeringResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ExpressRouteCircuitPeeringResource"/> object. </returns>
        public virtual ExpressRouteCircuitPeeringResource GetExpressRouteCircuitPeeringResource(ResourceIdentifier id)
        {
            ExpressRouteCircuitPeeringResource.ValidateResourceId(id);
            return new ExpressRouteCircuitPeeringResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ExpressRouteCircuitConnectionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ExpressRouteCircuitConnectionResource.CreateResourceIdentifier" /> to create an <see cref="ExpressRouteCircuitConnectionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ExpressRouteCircuitConnectionResource"/> object. </returns>
        public virtual ExpressRouteCircuitConnectionResource GetExpressRouteCircuitConnectionResource(ResourceIdentifier id)
        {
            ExpressRouteCircuitConnectionResource.ValidateResourceId(id);
            return new ExpressRouteCircuitConnectionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="PeerExpressRouteCircuitConnectionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="PeerExpressRouteCircuitConnectionResource.CreateResourceIdentifier" /> to create a <see cref="PeerExpressRouteCircuitConnectionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="PeerExpressRouteCircuitConnectionResource"/> object. </returns>
        public virtual PeerExpressRouteCircuitConnectionResource GetPeerExpressRouteCircuitConnectionResource(ResourceIdentifier id)
        {
            PeerExpressRouteCircuitConnectionResource.ValidateResourceId(id);
            return new PeerExpressRouteCircuitConnectionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ExpressRouteCircuitResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ExpressRouteCircuitResource.CreateResourceIdentifier" /> to create an <see cref="ExpressRouteCircuitResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ExpressRouteCircuitResource"/> object. </returns>
        public virtual ExpressRouteCircuitResource GetExpressRouteCircuitResource(ResourceIdentifier id)
        {
            ExpressRouteCircuitResource.ValidateResourceId(id);
            return new ExpressRouteCircuitResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ExpressRouteCrossConnectionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ExpressRouteCrossConnectionResource.CreateResourceIdentifier" /> to create an <see cref="ExpressRouteCrossConnectionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ExpressRouteCrossConnectionResource"/> object. </returns>
        public virtual ExpressRouteCrossConnectionResource GetExpressRouteCrossConnectionResource(ResourceIdentifier id)
        {
            ExpressRouteCrossConnectionResource.ValidateResourceId(id);
            return new ExpressRouteCrossConnectionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ExpressRouteCrossConnectionPeeringResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ExpressRouteCrossConnectionPeeringResource.CreateResourceIdentifier" /> to create an <see cref="ExpressRouteCrossConnectionPeeringResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ExpressRouteCrossConnectionPeeringResource"/> object. </returns>
        public virtual ExpressRouteCrossConnectionPeeringResource GetExpressRouteCrossConnectionPeeringResource(ResourceIdentifier id)
        {
            ExpressRouteCrossConnectionPeeringResource.ValidateResourceId(id);
            return new ExpressRouteCrossConnectionPeeringResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ExpressRoutePortsLocationResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ExpressRoutePortsLocationResource.CreateResourceIdentifier" /> to create an <see cref="ExpressRoutePortsLocationResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ExpressRoutePortsLocationResource"/> object. </returns>
        public virtual ExpressRoutePortsLocationResource GetExpressRoutePortsLocationResource(ResourceIdentifier id)
        {
            ExpressRoutePortsLocationResource.ValidateResourceId(id);
            return new ExpressRoutePortsLocationResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ExpressRoutePortResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ExpressRoutePortResource.CreateResourceIdentifier" /> to create an <see cref="ExpressRoutePortResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ExpressRoutePortResource"/> object. </returns>
        public virtual ExpressRoutePortResource GetExpressRoutePortResource(ResourceIdentifier id)
        {
            ExpressRoutePortResource.ValidateResourceId(id);
            return new ExpressRoutePortResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ExpressRouteLinkResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ExpressRouteLinkResource.CreateResourceIdentifier" /> to create an <see cref="ExpressRouteLinkResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ExpressRouteLinkResource"/> object. </returns>
        public virtual ExpressRouteLinkResource GetExpressRouteLinkResource(ResourceIdentifier id)
        {
            ExpressRouteLinkResource.ValidateResourceId(id);
            return new ExpressRouteLinkResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ExpressRoutePortAuthorizationResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ExpressRoutePortAuthorizationResource.CreateResourceIdentifier" /> to create an <see cref="ExpressRoutePortAuthorizationResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ExpressRoutePortAuthorizationResource"/> object. </returns>
        public virtual ExpressRoutePortAuthorizationResource GetExpressRoutePortAuthorizationResource(ResourceIdentifier id)
        {
            ExpressRoutePortAuthorizationResource.ValidateResourceId(id);
            return new ExpressRoutePortAuthorizationResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="FirewallPolicyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="FirewallPolicyResource.CreateResourceIdentifier" /> to create a <see cref="FirewallPolicyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="FirewallPolicyResource"/> object. </returns>
        public virtual FirewallPolicyResource GetFirewallPolicyResource(ResourceIdentifier id)
        {
            FirewallPolicyResource.ValidateResourceId(id);
            return new FirewallPolicyResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="FirewallPolicyRuleCollectionGroupResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="FirewallPolicyRuleCollectionGroupResource.CreateResourceIdentifier" /> to create a <see cref="FirewallPolicyRuleCollectionGroupResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="FirewallPolicyRuleCollectionGroupResource"/> object. </returns>
        public virtual FirewallPolicyRuleCollectionGroupResource GetFirewallPolicyRuleCollectionGroupResource(ResourceIdentifier id)
        {
            FirewallPolicyRuleCollectionGroupResource.ValidateResourceId(id);
            return new FirewallPolicyRuleCollectionGroupResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="PolicySignaturesOverridesForIdpsResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="PolicySignaturesOverridesForIdpsResource.CreateResourceIdentifier" /> to create a <see cref="PolicySignaturesOverridesForIdpsResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="PolicySignaturesOverridesForIdpsResource"/> object. </returns>
        public virtual PolicySignaturesOverridesForIdpsResource GetPolicySignaturesOverridesForIdpsResource(ResourceIdentifier id)
        {
            PolicySignaturesOverridesForIdpsResource.ValidateResourceId(id);
            return new PolicySignaturesOverridesForIdpsResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="FirewallPolicyDraftResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="FirewallPolicyDraftResource.CreateResourceIdentifier" /> to create a <see cref="FirewallPolicyDraftResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="FirewallPolicyDraftResource"/> object. </returns>
        public virtual FirewallPolicyDraftResource GetFirewallPolicyDraftResource(ResourceIdentifier id)
        {
            FirewallPolicyDraftResource.ValidateResourceId(id);
            return new FirewallPolicyDraftResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="FirewallPolicyRuleCollectionGroupDraftResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="FirewallPolicyRuleCollectionGroupDraftResource.CreateResourceIdentifier" /> to create a <see cref="FirewallPolicyRuleCollectionGroupDraftResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="FirewallPolicyRuleCollectionGroupDraftResource"/> object. </returns>
        public virtual FirewallPolicyRuleCollectionGroupDraftResource GetFirewallPolicyRuleCollectionGroupDraftResource(ResourceIdentifier id)
        {
            FirewallPolicyRuleCollectionGroupDraftResource.ValidateResourceId(id);
            return new FirewallPolicyRuleCollectionGroupDraftResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="IPAllocationResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="IPAllocationResource.CreateResourceIdentifier" /> to create an <see cref="IPAllocationResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="IPAllocationResource"/> object. </returns>
        public virtual IPAllocationResource GetIPAllocationResource(ResourceIdentifier id)
        {
            IPAllocationResource.ValidateResourceId(id);
            return new IPAllocationResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="IPGroupResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="IPGroupResource.CreateResourceIdentifier" /> to create an <see cref="IPGroupResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="IPGroupResource"/> object. </returns>
        public virtual IPGroupResource GetIPGroupResource(ResourceIdentifier id)
        {
            IPGroupResource.ValidateResourceId(id);
            return new IPGroupResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="LoadBalancerResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="LoadBalancerResource.CreateResourceIdentifier" /> to create a <see cref="LoadBalancerResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="LoadBalancerResource"/> object. </returns>
        public virtual LoadBalancerResource GetLoadBalancerResource(ResourceIdentifier id)
        {
            LoadBalancerResource.ValidateResourceId(id);
            return new LoadBalancerResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="BackendAddressPoolResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="BackendAddressPoolResource.CreateResourceIdentifier" /> to create a <see cref="BackendAddressPoolResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="BackendAddressPoolResource"/> object. </returns>
        public virtual BackendAddressPoolResource GetBackendAddressPoolResource(ResourceIdentifier id)
        {
            BackendAddressPoolResource.ValidateResourceId(id);
            return new BackendAddressPoolResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="FrontendIPConfigurationResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="FrontendIPConfigurationResource.CreateResourceIdentifier" /> to create a <see cref="FrontendIPConfigurationResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="FrontendIPConfigurationResource"/> object. </returns>
        public virtual FrontendIPConfigurationResource GetFrontendIPConfigurationResource(ResourceIdentifier id)
        {
            FrontendIPConfigurationResource.ValidateResourceId(id);
            return new FrontendIPConfigurationResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="InboundNatRuleResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="InboundNatRuleResource.CreateResourceIdentifier" /> to create an <see cref="InboundNatRuleResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="InboundNatRuleResource"/> object. </returns>
        public virtual InboundNatRuleResource GetInboundNatRuleResource(ResourceIdentifier id)
        {
            InboundNatRuleResource.ValidateResourceId(id);
            return new InboundNatRuleResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="LoadBalancingRuleResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="LoadBalancingRuleResource.CreateResourceIdentifier" /> to create a <see cref="LoadBalancingRuleResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="LoadBalancingRuleResource"/> object. </returns>
        public virtual LoadBalancingRuleResource GetLoadBalancingRuleResource(ResourceIdentifier id)
        {
            LoadBalancingRuleResource.ValidateResourceId(id);
            return new LoadBalancingRuleResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="OutboundRuleResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="OutboundRuleResource.CreateResourceIdentifier" /> to create an <see cref="OutboundRuleResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="OutboundRuleResource"/> object. </returns>
        public virtual OutboundRuleResource GetOutboundRuleResource(ResourceIdentifier id)
        {
            OutboundRuleResource.ValidateResourceId(id);
            return new OutboundRuleResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ProbeResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ProbeResource.CreateResourceIdentifier" /> to create a <see cref="ProbeResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ProbeResource"/> object. </returns>
        public virtual ProbeResource GetProbeResource(ResourceIdentifier id)
        {
            ProbeResource.ValidateResourceId(id);
            return new ProbeResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="NatGatewayResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="NatGatewayResource.CreateResourceIdentifier" /> to create a <see cref="NatGatewayResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="NatGatewayResource"/> object. </returns>
        public virtual NatGatewayResource GetNatGatewayResource(ResourceIdentifier id)
        {
            NatGatewayResource.ValidateResourceId(id);
            return new NatGatewayResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="NetworkInterfaceResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="NetworkInterfaceResource.CreateResourceIdentifier" /> to create a <see cref="NetworkInterfaceResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="NetworkInterfaceResource"/> object. </returns>
        public virtual NetworkInterfaceResource GetNetworkInterfaceResource(ResourceIdentifier id)
        {
            NetworkInterfaceResource.ValidateResourceId(id);
            return new NetworkInterfaceResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="NetworkInterfaceIPConfigurationResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="NetworkInterfaceIPConfigurationResource.CreateResourceIdentifier" /> to create a <see cref="NetworkInterfaceIPConfigurationResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="NetworkInterfaceIPConfigurationResource"/> object. </returns>
        public virtual NetworkInterfaceIPConfigurationResource GetNetworkInterfaceIPConfigurationResource(ResourceIdentifier id)
        {
            NetworkInterfaceIPConfigurationResource.ValidateResourceId(id);
            return new NetworkInterfaceIPConfigurationResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="NetworkInterfaceTapConfigurationResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="NetworkInterfaceTapConfigurationResource.CreateResourceIdentifier" /> to create a <see cref="NetworkInterfaceTapConfigurationResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="NetworkInterfaceTapConfigurationResource"/> object. </returns>
        public virtual NetworkInterfaceTapConfigurationResource GetNetworkInterfaceTapConfigurationResource(ResourceIdentifier id)
        {
            NetworkInterfaceTapConfigurationResource.ValidateResourceId(id);
            return new NetworkInterfaceTapConfigurationResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="NetworkManagerResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="NetworkManagerResource.CreateResourceIdentifier" /> to create a <see cref="NetworkManagerResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="NetworkManagerResource"/> object. </returns>
        public virtual NetworkManagerResource GetNetworkManagerResource(ResourceIdentifier id)
        {
            NetworkManagerResource.ValidateResourceId(id);
            return new NetworkManagerResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SubscriptionNetworkManagerConnectionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SubscriptionNetworkManagerConnectionResource.CreateResourceIdentifier" /> to create a <see cref="SubscriptionNetworkManagerConnectionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SubscriptionNetworkManagerConnectionResource"/> object. </returns>
        public virtual SubscriptionNetworkManagerConnectionResource GetSubscriptionNetworkManagerConnectionResource(ResourceIdentifier id)
        {
            SubscriptionNetworkManagerConnectionResource.ValidateResourceId(id);
            return new SubscriptionNetworkManagerConnectionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ManagementGroupNetworkManagerConnectionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ManagementGroupNetworkManagerConnectionResource.CreateResourceIdentifier" /> to create a <see cref="ManagementGroupNetworkManagerConnectionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ManagementGroupNetworkManagerConnectionResource"/> object. </returns>
        public virtual ManagementGroupNetworkManagerConnectionResource GetManagementGroupNetworkManagerConnectionResource(ResourceIdentifier id)
        {
            ManagementGroupNetworkManagerConnectionResource.ValidateResourceId(id);
            return new ManagementGroupNetworkManagerConnectionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ConnectivityConfigurationResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ConnectivityConfigurationResource.CreateResourceIdentifier" /> to create a <see cref="ConnectivityConfigurationResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ConnectivityConfigurationResource"/> object. </returns>
        public virtual ConnectivityConfigurationResource GetConnectivityConfigurationResource(ResourceIdentifier id)
        {
            ConnectivityConfigurationResource.ValidateResourceId(id);
            return new ConnectivityConfigurationResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="NetworkGroupResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="NetworkGroupResource.CreateResourceIdentifier" /> to create a <see cref="NetworkGroupResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="NetworkGroupResource"/> object. </returns>
        public virtual NetworkGroupResource GetNetworkGroupResource(ResourceIdentifier id)
        {
            NetworkGroupResource.ValidateResourceId(id);
            return new NetworkGroupResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="NetworkGroupStaticMemberResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="NetworkGroupStaticMemberResource.CreateResourceIdentifier" /> to create a <see cref="NetworkGroupStaticMemberResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="NetworkGroupStaticMemberResource"/> object. </returns>
        public virtual NetworkGroupStaticMemberResource GetNetworkGroupStaticMemberResource(ResourceIdentifier id)
        {
            NetworkGroupStaticMemberResource.ValidateResourceId(id);
            return new NetworkGroupStaticMemberResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ScopeConnectionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ScopeConnectionResource.CreateResourceIdentifier" /> to create a <see cref="ScopeConnectionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ScopeConnectionResource"/> object. </returns>
        public virtual ScopeConnectionResource GetScopeConnectionResource(ResourceIdentifier id)
        {
            ScopeConnectionResource.ValidateResourceId(id);
            return new ScopeConnectionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SecurityAdminConfigurationResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SecurityAdminConfigurationResource.CreateResourceIdentifier" /> to create a <see cref="SecurityAdminConfigurationResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SecurityAdminConfigurationResource"/> object. </returns>
        public virtual SecurityAdminConfigurationResource GetSecurityAdminConfigurationResource(ResourceIdentifier id)
        {
            SecurityAdminConfigurationResource.ValidateResourceId(id);
            return new SecurityAdminConfigurationResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="AdminRuleGroupResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="AdminRuleGroupResource.CreateResourceIdentifier" /> to create an <see cref="AdminRuleGroupResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="AdminRuleGroupResource"/> object. </returns>
        public virtual AdminRuleGroupResource GetAdminRuleGroupResource(ResourceIdentifier id)
        {
            AdminRuleGroupResource.ValidateResourceId(id);
            return new AdminRuleGroupResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="BaseAdminRuleResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="BaseAdminRuleResource.CreateResourceIdentifier" /> to create a <see cref="BaseAdminRuleResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="BaseAdminRuleResource"/> object. </returns>
        public virtual BaseAdminRuleResource GetBaseAdminRuleResource(ResourceIdentifier id)
        {
            BaseAdminRuleResource.ValidateResourceId(id);
            return new BaseAdminRuleResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="NetworkManagerSecurityUserConfigurationResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="NetworkManagerSecurityUserConfigurationResource.CreateResourceIdentifier" /> to create a <see cref="NetworkManagerSecurityUserConfigurationResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="NetworkManagerSecurityUserConfigurationResource"/> object. </returns>
        public virtual NetworkManagerSecurityUserConfigurationResource GetNetworkManagerSecurityUserConfigurationResource(ResourceIdentifier id)
        {
            NetworkManagerSecurityUserConfigurationResource.ValidateResourceId(id);
            return new NetworkManagerSecurityUserConfigurationResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="NetworkManagerSecurityUserRulesResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="NetworkManagerSecurityUserRulesResource.CreateResourceIdentifier" /> to create a <see cref="NetworkManagerSecurityUserRulesResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="NetworkManagerSecurityUserRulesResource"/> object. </returns>
        public virtual NetworkManagerSecurityUserRulesResource GetNetworkManagerSecurityUserRulesResource(ResourceIdentifier id)
        {
            NetworkManagerSecurityUserRulesResource.ValidateResourceId(id);
            return new NetworkManagerSecurityUserRulesResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="NetworkManagerSecurityUserRuleResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="NetworkManagerSecurityUserRuleResource.CreateResourceIdentifier" /> to create a <see cref="NetworkManagerSecurityUserRuleResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="NetworkManagerSecurityUserRuleResource"/> object. </returns>
        public virtual NetworkManagerSecurityUserRuleResource GetNetworkManagerSecurityUserRuleResource(ResourceIdentifier id)
        {
            NetworkManagerSecurityUserRuleResource.ValidateResourceId(id);
            return new NetworkManagerSecurityUserRuleResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="NetworkManagerRoutingConfigurationResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="NetworkManagerRoutingConfigurationResource.CreateResourceIdentifier" /> to create a <see cref="NetworkManagerRoutingConfigurationResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="NetworkManagerRoutingConfigurationResource"/> object. </returns>
        public virtual NetworkManagerRoutingConfigurationResource GetNetworkManagerRoutingConfigurationResource(ResourceIdentifier id)
        {
            NetworkManagerRoutingConfigurationResource.ValidateResourceId(id);
            return new NetworkManagerRoutingConfigurationResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="NetworkManagerRoutingRulesResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="NetworkManagerRoutingRulesResource.CreateResourceIdentifier" /> to create a <see cref="NetworkManagerRoutingRulesResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="NetworkManagerRoutingRulesResource"/> object. </returns>
        public virtual NetworkManagerRoutingRulesResource GetNetworkManagerRoutingRulesResource(ResourceIdentifier id)
        {
            NetworkManagerRoutingRulesResource.ValidateResourceId(id);
            return new NetworkManagerRoutingRulesResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="NetworkManagerRoutingRuleResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="NetworkManagerRoutingRuleResource.CreateResourceIdentifier" /> to create a <see cref="NetworkManagerRoutingRuleResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="NetworkManagerRoutingRuleResource"/> object. </returns>
        public virtual NetworkManagerRoutingRuleResource GetNetworkManagerRoutingRuleResource(ResourceIdentifier id)
        {
            NetworkManagerRoutingRuleResource.ValidateResourceId(id);
            return new NetworkManagerRoutingRuleResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="NetworkProfileResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="NetworkProfileResource.CreateResourceIdentifier" /> to create a <see cref="NetworkProfileResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="NetworkProfileResource"/> object. </returns>
        public virtual NetworkProfileResource GetNetworkProfileResource(ResourceIdentifier id)
        {
            NetworkProfileResource.ValidateResourceId(id);
            return new NetworkProfileResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="NetworkSecurityGroupResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="NetworkSecurityGroupResource.CreateResourceIdentifier" /> to create a <see cref="NetworkSecurityGroupResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="NetworkSecurityGroupResource"/> object. </returns>
        public virtual NetworkSecurityGroupResource GetNetworkSecurityGroupResource(ResourceIdentifier id)
        {
            NetworkSecurityGroupResource.ValidateResourceId(id);
            return new NetworkSecurityGroupResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SecurityRuleResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SecurityRuleResource.CreateResourceIdentifier" /> to create a <see cref="SecurityRuleResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SecurityRuleResource"/> object. </returns>
        public virtual SecurityRuleResource GetSecurityRuleResource(ResourceIdentifier id)
        {
            SecurityRuleResource.ValidateResourceId(id);
            return new SecurityRuleResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DefaultSecurityRuleResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DefaultSecurityRuleResource.CreateResourceIdentifier" /> to create a <see cref="DefaultSecurityRuleResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DefaultSecurityRuleResource"/> object. </returns>
        public virtual DefaultSecurityRuleResource GetDefaultSecurityRuleResource(ResourceIdentifier id)
        {
            DefaultSecurityRuleResource.ValidateResourceId(id);
            return new DefaultSecurityRuleResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="NetworkVirtualApplianceResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="NetworkVirtualApplianceResource.CreateResourceIdentifier" /> to create a <see cref="NetworkVirtualApplianceResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="NetworkVirtualApplianceResource"/> object. </returns>
        public virtual NetworkVirtualApplianceResource GetNetworkVirtualApplianceResource(ResourceIdentifier id)
        {
            NetworkVirtualApplianceResource.ValidateResourceId(id);
            return new NetworkVirtualApplianceResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="VirtualApplianceSiteResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="VirtualApplianceSiteResource.CreateResourceIdentifier" /> to create a <see cref="VirtualApplianceSiteResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="VirtualApplianceSiteResource"/> object. </returns>
        public virtual VirtualApplianceSiteResource GetVirtualApplianceSiteResource(ResourceIdentifier id)
        {
            VirtualApplianceSiteResource.ValidateResourceId(id);
            return new VirtualApplianceSiteResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="NetworkVirtualApplianceSkuResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="NetworkVirtualApplianceSkuResource.CreateResourceIdentifier" /> to create a <see cref="NetworkVirtualApplianceSkuResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="NetworkVirtualApplianceSkuResource"/> object. </returns>
        public virtual NetworkVirtualApplianceSkuResource GetNetworkVirtualApplianceSkuResource(ResourceIdentifier id)
        {
            NetworkVirtualApplianceSkuResource.ValidateResourceId(id);
            return new NetworkVirtualApplianceSkuResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="InboundSecurityRuleResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="InboundSecurityRuleResource.CreateResourceIdentifier" /> to create an <see cref="InboundSecurityRuleResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="InboundSecurityRuleResource"/> object. </returns>
        public virtual InboundSecurityRuleResource GetInboundSecurityRuleResource(ResourceIdentifier id)
        {
            InboundSecurityRuleResource.ValidateResourceId(id);
            return new InboundSecurityRuleResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="NetworkWatcherResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="NetworkWatcherResource.CreateResourceIdentifier" /> to create a <see cref="NetworkWatcherResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="NetworkWatcherResource"/> object. </returns>
        public virtual NetworkWatcherResource GetNetworkWatcherResource(ResourceIdentifier id)
        {
            NetworkWatcherResource.ValidateResourceId(id);
            return new NetworkWatcherResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="PacketCaptureResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="PacketCaptureResource.CreateResourceIdentifier" /> to create a <see cref="PacketCaptureResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="PacketCaptureResource"/> object. </returns>
        public virtual PacketCaptureResource GetPacketCaptureResource(ResourceIdentifier id)
        {
            PacketCaptureResource.ValidateResourceId(id);
            return new PacketCaptureResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ConnectionMonitorResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ConnectionMonitorResource.CreateResourceIdentifier" /> to create a <see cref="ConnectionMonitorResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ConnectionMonitorResource"/> object. </returns>
        public virtual ConnectionMonitorResource GetConnectionMonitorResource(ResourceIdentifier id)
        {
            ConnectionMonitorResource.ValidateResourceId(id);
            return new ConnectionMonitorResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="FlowLogResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="FlowLogResource.CreateResourceIdentifier" /> to create a <see cref="FlowLogResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="FlowLogResource"/> object. </returns>
        public virtual FlowLogResource GetFlowLogResource(ResourceIdentifier id)
        {
            FlowLogResource.ValidateResourceId(id);
            return new FlowLogResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="PrivateEndpointResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="PrivateEndpointResource.CreateResourceIdentifier" /> to create a <see cref="PrivateEndpointResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="PrivateEndpointResource"/> object. </returns>
        public virtual PrivateEndpointResource GetPrivateEndpointResource(ResourceIdentifier id)
        {
            PrivateEndpointResource.ValidateResourceId(id);
            return new PrivateEndpointResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="PrivateDnsZoneGroupResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="PrivateDnsZoneGroupResource.CreateResourceIdentifier" /> to create a <see cref="PrivateDnsZoneGroupResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="PrivateDnsZoneGroupResource"/> object. </returns>
        public virtual PrivateDnsZoneGroupResource GetPrivateDnsZoneGroupResource(ResourceIdentifier id)
        {
            PrivateDnsZoneGroupResource.ValidateResourceId(id);
            return new PrivateDnsZoneGroupResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="PrivateLinkServiceResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="PrivateLinkServiceResource.CreateResourceIdentifier" /> to create a <see cref="PrivateLinkServiceResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="PrivateLinkServiceResource"/> object. </returns>
        public virtual PrivateLinkServiceResource GetPrivateLinkServiceResource(ResourceIdentifier id)
        {
            PrivateLinkServiceResource.ValidateResourceId(id);
            return new PrivateLinkServiceResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="NetworkPrivateEndpointConnectionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="NetworkPrivateEndpointConnectionResource.CreateResourceIdentifier" /> to create a <see cref="NetworkPrivateEndpointConnectionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="NetworkPrivateEndpointConnectionResource"/> object. </returns>
        public virtual NetworkPrivateEndpointConnectionResource GetNetworkPrivateEndpointConnectionResource(ResourceIdentifier id)
        {
            NetworkPrivateEndpointConnectionResource.ValidateResourceId(id);
            return new NetworkPrivateEndpointConnectionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="PublicIPAddressResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="PublicIPAddressResource.CreateResourceIdentifier" /> to create a <see cref="PublicIPAddressResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="PublicIPAddressResource"/> object. </returns>
        public virtual PublicIPAddressResource GetPublicIPAddressResource(ResourceIdentifier id)
        {
            PublicIPAddressResource.ValidateResourceId(id);
            return new PublicIPAddressResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="PublicIPPrefixResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="PublicIPPrefixResource.CreateResourceIdentifier" /> to create a <see cref="PublicIPPrefixResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="PublicIPPrefixResource"/> object. </returns>
        public virtual PublicIPPrefixResource GetPublicIPPrefixResource(ResourceIdentifier id)
        {
            PublicIPPrefixResource.ValidateResourceId(id);
            return new PublicIPPrefixResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="RouteFilterResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="RouteFilterResource.CreateResourceIdentifier" /> to create a <see cref="RouteFilterResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="RouteFilterResource"/> object. </returns>
        public virtual RouteFilterResource GetRouteFilterResource(ResourceIdentifier id)
        {
            RouteFilterResource.ValidateResourceId(id);
            return new RouteFilterResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="RouteFilterRuleResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="RouteFilterRuleResource.CreateResourceIdentifier" /> to create a <see cref="RouteFilterRuleResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="RouteFilterRuleResource"/> object. </returns>
        public virtual RouteFilterRuleResource GetRouteFilterRuleResource(ResourceIdentifier id)
        {
            RouteFilterRuleResource.ValidateResourceId(id);
            return new RouteFilterRuleResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="RouteTableResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="RouteTableResource.CreateResourceIdentifier" /> to create a <see cref="RouteTableResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="RouteTableResource"/> object. </returns>
        public virtual RouteTableResource GetRouteTableResource(ResourceIdentifier id)
        {
            RouteTableResource.ValidateResourceId(id);
            return new RouteTableResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="RouteResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="RouteResource.CreateResourceIdentifier" /> to create a <see cref="RouteResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="RouteResource"/> object. </returns>
        public virtual RouteResource GetRouteResource(ResourceIdentifier id)
        {
            RouteResource.ValidateResourceId(id);
            return new RouteResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SecurityPartnerProviderResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SecurityPartnerProviderResource.CreateResourceIdentifier" /> to create a <see cref="SecurityPartnerProviderResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SecurityPartnerProviderResource"/> object. </returns>
        public virtual SecurityPartnerProviderResource GetSecurityPartnerProviderResource(ResourceIdentifier id)
        {
            SecurityPartnerProviderResource.ValidateResourceId(id);
            return new SecurityPartnerProviderResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ServiceEndpointPolicyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ServiceEndpointPolicyResource.CreateResourceIdentifier" /> to create a <see cref="ServiceEndpointPolicyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ServiceEndpointPolicyResource"/> object. </returns>
        public virtual ServiceEndpointPolicyResource GetServiceEndpointPolicyResource(ResourceIdentifier id)
        {
            ServiceEndpointPolicyResource.ValidateResourceId(id);
            return new ServiceEndpointPolicyResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ServiceEndpointPolicyDefinitionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ServiceEndpointPolicyDefinitionResource.CreateResourceIdentifier" /> to create a <see cref="ServiceEndpointPolicyDefinitionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ServiceEndpointPolicyDefinitionResource"/> object. </returns>
        public virtual ServiceEndpointPolicyDefinitionResource GetServiceEndpointPolicyDefinitionResource(ResourceIdentifier id)
        {
            ServiceEndpointPolicyDefinitionResource.ValidateResourceId(id);
            return new ServiceEndpointPolicyDefinitionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="VirtualNetworkResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="VirtualNetworkResource.CreateResourceIdentifier" /> to create a <see cref="VirtualNetworkResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="VirtualNetworkResource"/> object. </returns>
        public virtual VirtualNetworkResource GetVirtualNetworkResource(ResourceIdentifier id)
        {
            VirtualNetworkResource.ValidateResourceId(id);
            return new VirtualNetworkResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SubnetResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SubnetResource.CreateResourceIdentifier" /> to create a <see cref="SubnetResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SubnetResource"/> object. </returns>
        public virtual SubnetResource GetSubnetResource(ResourceIdentifier id)
        {
            SubnetResource.ValidateResourceId(id);
            return new SubnetResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="VirtualNetworkPeeringResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="VirtualNetworkPeeringResource.CreateResourceIdentifier" /> to create a <see cref="VirtualNetworkPeeringResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="VirtualNetworkPeeringResource"/> object. </returns>
        public virtual VirtualNetworkPeeringResource GetVirtualNetworkPeeringResource(ResourceIdentifier id)
        {
            VirtualNetworkPeeringResource.ValidateResourceId(id);
            return new VirtualNetworkPeeringResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="VirtualNetworkGatewayResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="VirtualNetworkGatewayResource.CreateResourceIdentifier" /> to create a <see cref="VirtualNetworkGatewayResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="VirtualNetworkGatewayResource"/> object. </returns>
        public virtual VirtualNetworkGatewayResource GetVirtualNetworkGatewayResource(ResourceIdentifier id)
        {
            VirtualNetworkGatewayResource.ValidateResourceId(id);
            return new VirtualNetworkGatewayResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="VirtualNetworkGatewayConnectionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="VirtualNetworkGatewayConnectionResource.CreateResourceIdentifier" /> to create a <see cref="VirtualNetworkGatewayConnectionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="VirtualNetworkGatewayConnectionResource"/> object. </returns>
        public virtual VirtualNetworkGatewayConnectionResource GetVirtualNetworkGatewayConnectionResource(ResourceIdentifier id)
        {
            VirtualNetworkGatewayConnectionResource.ValidateResourceId(id);
            return new VirtualNetworkGatewayConnectionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="LocalNetworkGatewayResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="LocalNetworkGatewayResource.CreateResourceIdentifier" /> to create a <see cref="LocalNetworkGatewayResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="LocalNetworkGatewayResource"/> object. </returns>
        public virtual LocalNetworkGatewayResource GetLocalNetworkGatewayResource(ResourceIdentifier id)
        {
            LocalNetworkGatewayResource.ValidateResourceId(id);
            return new LocalNetworkGatewayResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="VirtualNetworkGatewayNatRuleResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="VirtualNetworkGatewayNatRuleResource.CreateResourceIdentifier" /> to create a <see cref="VirtualNetworkGatewayNatRuleResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="VirtualNetworkGatewayNatRuleResource"/> object. </returns>
        public virtual VirtualNetworkGatewayNatRuleResource GetVirtualNetworkGatewayNatRuleResource(ResourceIdentifier id)
        {
            VirtualNetworkGatewayNatRuleResource.ValidateResourceId(id);
            return new VirtualNetworkGatewayNatRuleResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="VirtualNetworkTapResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="VirtualNetworkTapResource.CreateResourceIdentifier" /> to create a <see cref="VirtualNetworkTapResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="VirtualNetworkTapResource"/> object. </returns>
        public virtual VirtualNetworkTapResource GetVirtualNetworkTapResource(ResourceIdentifier id)
        {
            VirtualNetworkTapResource.ValidateResourceId(id);
            return new VirtualNetworkTapResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="VirtualRouterResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="VirtualRouterResource.CreateResourceIdentifier" /> to create a <see cref="VirtualRouterResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="VirtualRouterResource"/> object. </returns>
        public virtual VirtualRouterResource GetVirtualRouterResource(ResourceIdentifier id)
        {
            VirtualRouterResource.ValidateResourceId(id);
            return new VirtualRouterResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="VirtualRouterPeeringResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="VirtualRouterPeeringResource.CreateResourceIdentifier" /> to create a <see cref="VirtualRouterPeeringResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="VirtualRouterPeeringResource"/> object. </returns>
        public virtual VirtualRouterPeeringResource GetVirtualRouterPeeringResource(ResourceIdentifier id)
        {
            VirtualRouterPeeringResource.ValidateResourceId(id);
            return new VirtualRouterPeeringResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="VirtualWanResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="VirtualWanResource.CreateResourceIdentifier" /> to create a <see cref="VirtualWanResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="VirtualWanResource"/> object. </returns>
        public virtual VirtualWanResource GetVirtualWanResource(ResourceIdentifier id)
        {
            VirtualWanResource.ValidateResourceId(id);
            return new VirtualWanResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="VpnSiteResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="VpnSiteResource.CreateResourceIdentifier" /> to create a <see cref="VpnSiteResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="VpnSiteResource"/> object. </returns>
        public virtual VpnSiteResource GetVpnSiteResource(ResourceIdentifier id)
        {
            VpnSiteResource.ValidateResourceId(id);
            return new VpnSiteResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="VpnSiteLinkResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="VpnSiteLinkResource.CreateResourceIdentifier" /> to create a <see cref="VpnSiteLinkResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="VpnSiteLinkResource"/> object. </returns>
        public virtual VpnSiteLinkResource GetVpnSiteLinkResource(ResourceIdentifier id)
        {
            VpnSiteLinkResource.ValidateResourceId(id);
            return new VpnSiteLinkResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="VpnServerConfigurationResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="VpnServerConfigurationResource.CreateResourceIdentifier" /> to create a <see cref="VpnServerConfigurationResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="VpnServerConfigurationResource"/> object. </returns>
        public virtual VpnServerConfigurationResource GetVpnServerConfigurationResource(ResourceIdentifier id)
        {
            VpnServerConfigurationResource.ValidateResourceId(id);
            return new VpnServerConfigurationResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="VpnServerConfigurationPolicyGroupResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="VpnServerConfigurationPolicyGroupResource.CreateResourceIdentifier" /> to create a <see cref="VpnServerConfigurationPolicyGroupResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="VpnServerConfigurationPolicyGroupResource"/> object. </returns>
        public virtual VpnServerConfigurationPolicyGroupResource GetVpnServerConfigurationPolicyGroupResource(ResourceIdentifier id)
        {
            VpnServerConfigurationPolicyGroupResource.ValidateResourceId(id);
            return new VpnServerConfigurationPolicyGroupResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="VirtualHubResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="VirtualHubResource.CreateResourceIdentifier" /> to create a <see cref="VirtualHubResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="VirtualHubResource"/> object. </returns>
        public virtual VirtualHubResource GetVirtualHubResource(ResourceIdentifier id)
        {
            VirtualHubResource.ValidateResourceId(id);
            return new VirtualHubResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="RouteMapResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="RouteMapResource.CreateResourceIdentifier" /> to create a <see cref="RouteMapResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="RouteMapResource"/> object. </returns>
        public virtual RouteMapResource GetRouteMapResource(ResourceIdentifier id)
        {
            RouteMapResource.ValidateResourceId(id);
            return new RouteMapResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="HubVirtualNetworkConnectionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="HubVirtualNetworkConnectionResource.CreateResourceIdentifier" /> to create a <see cref="HubVirtualNetworkConnectionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="HubVirtualNetworkConnectionResource"/> object. </returns>
        public virtual HubVirtualNetworkConnectionResource GetHubVirtualNetworkConnectionResource(ResourceIdentifier id)
        {
            HubVirtualNetworkConnectionResource.ValidateResourceId(id);
            return new HubVirtualNetworkConnectionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="VpnGatewayResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="VpnGatewayResource.CreateResourceIdentifier" /> to create a <see cref="VpnGatewayResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="VpnGatewayResource"/> object. </returns>
        public virtual VpnGatewayResource GetVpnGatewayResource(ResourceIdentifier id)
        {
            VpnGatewayResource.ValidateResourceId(id);
            return new VpnGatewayResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="VpnLinkConnectionSharedKeyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="VpnLinkConnectionSharedKeyResource.CreateResourceIdentifier" /> to create a <see cref="VpnLinkConnectionSharedKeyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="VpnLinkConnectionSharedKeyResource"/> object. </returns>
        public virtual VpnLinkConnectionSharedKeyResource GetVpnLinkConnectionSharedKeyResource(ResourceIdentifier id)
        {
            VpnLinkConnectionSharedKeyResource.ValidateResourceId(id);
            return new VpnLinkConnectionSharedKeyResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="VpnConnectionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="VpnConnectionResource.CreateResourceIdentifier" /> to create a <see cref="VpnConnectionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="VpnConnectionResource"/> object. </returns>
        public virtual VpnConnectionResource GetVpnConnectionResource(ResourceIdentifier id)
        {
            VpnConnectionResource.ValidateResourceId(id);
            return new VpnConnectionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="VpnSiteLinkConnectionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="VpnSiteLinkConnectionResource.CreateResourceIdentifier" /> to create a <see cref="VpnSiteLinkConnectionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="VpnSiteLinkConnectionResource"/> object. </returns>
        public virtual VpnSiteLinkConnectionResource GetVpnSiteLinkConnectionResource(ResourceIdentifier id)
        {
            VpnSiteLinkConnectionResource.ValidateResourceId(id);
            return new VpnSiteLinkConnectionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="VpnGatewayNatRuleResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="VpnGatewayNatRuleResource.CreateResourceIdentifier" /> to create a <see cref="VpnGatewayNatRuleResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="VpnGatewayNatRuleResource"/> object. </returns>
        public virtual VpnGatewayNatRuleResource GetVpnGatewayNatRuleResource(ResourceIdentifier id)
        {
            VpnGatewayNatRuleResource.ValidateResourceId(id);
            return new VpnGatewayNatRuleResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="P2SVpnGatewayResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="P2SVpnGatewayResource.CreateResourceIdentifier" /> to create a <see cref="P2SVpnGatewayResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="P2SVpnGatewayResource"/> object. </returns>
        public virtual P2SVpnGatewayResource GetP2SVpnGatewayResource(ResourceIdentifier id)
        {
            P2SVpnGatewayResource.ValidateResourceId(id);
            return new P2SVpnGatewayResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="VirtualHubRouteTableV2Resource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="VirtualHubRouteTableV2Resource.CreateResourceIdentifier" /> to create a <see cref="VirtualHubRouteTableV2Resource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="VirtualHubRouteTableV2Resource"/> object. </returns>
        public virtual VirtualHubRouteTableV2Resource GetVirtualHubRouteTableV2Resource(ResourceIdentifier id)
        {
            VirtualHubRouteTableV2Resource.ValidateResourceId(id);
            return new VirtualHubRouteTableV2Resource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ExpressRouteGatewayResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ExpressRouteGatewayResource.CreateResourceIdentifier" /> to create an <see cref="ExpressRouteGatewayResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ExpressRouteGatewayResource"/> object. </returns>
        public virtual ExpressRouteGatewayResource GetExpressRouteGatewayResource(ResourceIdentifier id)
        {
            ExpressRouteGatewayResource.ValidateResourceId(id);
            return new ExpressRouteGatewayResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ExpressRouteConnectionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ExpressRouteConnectionResource.CreateResourceIdentifier" /> to create an <see cref="ExpressRouteConnectionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ExpressRouteConnectionResource"/> object. </returns>
        public virtual ExpressRouteConnectionResource GetExpressRouteConnectionResource(ResourceIdentifier id)
        {
            ExpressRouteConnectionResource.ValidateResourceId(id);
            return new ExpressRouteConnectionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="NetworkVirtualApplianceConnectionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="NetworkVirtualApplianceConnectionResource.CreateResourceIdentifier" /> to create a <see cref="NetworkVirtualApplianceConnectionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="NetworkVirtualApplianceConnectionResource"/> object. </returns>
        public virtual NetworkVirtualApplianceConnectionResource GetNetworkVirtualApplianceConnectionResource(ResourceIdentifier id)
        {
            NetworkVirtualApplianceConnectionResource.ValidateResourceId(id);
            return new NetworkVirtualApplianceConnectionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="BgpConnectionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="BgpConnectionResource.CreateResourceIdentifier" /> to create a <see cref="BgpConnectionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="BgpConnectionResource"/> object. </returns>
        public virtual BgpConnectionResource GetBgpConnectionResource(ResourceIdentifier id)
        {
            BgpConnectionResource.ValidateResourceId(id);
            return new BgpConnectionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="HubIPConfigurationResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="HubIPConfigurationResource.CreateResourceIdentifier" /> to create a <see cref="HubIPConfigurationResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="HubIPConfigurationResource"/> object. </returns>
        public virtual HubIPConfigurationResource GetHubIPConfigurationResource(ResourceIdentifier id)
        {
            HubIPConfigurationResource.ValidateResourceId(id);
            return new HubIPConfigurationResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="HubRouteTableResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="HubRouteTableResource.CreateResourceIdentifier" /> to create a <see cref="HubRouteTableResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="HubRouteTableResource"/> object. </returns>
        public virtual HubRouteTableResource GetHubRouteTableResource(ResourceIdentifier id)
        {
            HubRouteTableResource.ValidateResourceId(id);
            return new HubRouteTableResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="RoutingIntentResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="RoutingIntentResource.CreateResourceIdentifier" /> to create a <see cref="RoutingIntentResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="RoutingIntentResource"/> object. </returns>
        public virtual RoutingIntentResource GetRoutingIntentResource(ResourceIdentifier id)
        {
            RoutingIntentResource.ValidateResourceId(id);
            return new RoutingIntentResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="WebApplicationFirewallPolicyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="WebApplicationFirewallPolicyResource.CreateResourceIdentifier" /> to create a <see cref="WebApplicationFirewallPolicyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="WebApplicationFirewallPolicyResource"/> object. </returns>
        public virtual WebApplicationFirewallPolicyResource GetWebApplicationFirewallPolicyResource(ResourceIdentifier id)
        {
            WebApplicationFirewallPolicyResource.ValidateResourceId(id);
            return new WebApplicationFirewallPolicyResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="VirtualMachineScaleSetNetworkResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="VirtualMachineScaleSetNetworkResource.CreateResourceIdentifier" /> to create a <see cref="VirtualMachineScaleSetNetworkResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="VirtualMachineScaleSetNetworkResource"/> object. </returns>
        public virtual VirtualMachineScaleSetNetworkResource GetVirtualMachineScaleSetNetworkResource(ResourceIdentifier id)
        {
            VirtualMachineScaleSetNetworkResource.ValidateResourceId(id);
            return new VirtualMachineScaleSetNetworkResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="VirtualMachineScaleSetVmNetworkResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="VirtualMachineScaleSetVmNetworkResource.CreateResourceIdentifier" /> to create a <see cref="VirtualMachineScaleSetVmNetworkResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="VirtualMachineScaleSetVmNetworkResource"/> object. </returns>
        public virtual VirtualMachineScaleSetVmNetworkResource GetVirtualMachineScaleSetVmNetworkResource(ResourceIdentifier id)
        {
            VirtualMachineScaleSetVmNetworkResource.ValidateResourceId(id);
            return new VirtualMachineScaleSetVmNetworkResource(Client, id);
        }
    }
}
