// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Network
{
    public partial class ExpressRouteProviderPortData : IUtf8JsonSerializable, IJsonModel<ExpressRouteProviderPortData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ExpressRouteProviderPortData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ExpressRouteProviderPortData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ExpressRouteProviderPortData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ExpressRouteProviderPortData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (options.Format != "W" && Optional.IsDefined(ETag))
            {
                writer.WritePropertyName("etag"u8);
                writer.WriteStringValue(ETag.Value.ToString());
            }
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (options.Format != "W" && Optional.IsDefined(PortPairDescriptor))
            {
                writer.WritePropertyName("portPairDescriptor"u8);
                writer.WriteStringValue(PortPairDescriptor);
            }
            if (options.Format != "W" && Optional.IsDefined(PrimaryAzurePort))
            {
                writer.WritePropertyName("primaryAzurePort"u8);
                writer.WriteStringValue(PrimaryAzurePort);
            }
            if (options.Format != "W" && Optional.IsDefined(SecondaryAzurePort))
            {
                writer.WritePropertyName("secondaryAzurePort"u8);
                writer.WriteStringValue(SecondaryAzurePort);
            }
            if (Optional.IsDefined(PeeringLocation))
            {
                writer.WritePropertyName("peeringLocation"u8);
                writer.WriteStringValue(PeeringLocation);
            }
            if (Optional.IsDefined(OverprovisionFactor))
            {
                writer.WritePropertyName("overprovisionFactor"u8);
                writer.WriteNumberValue(OverprovisionFactor.Value);
            }
            if (Optional.IsDefined(PortBandwidthInMbps))
            {
                writer.WritePropertyName("portBandwidthInMbps"u8);
                writer.WriteNumberValue(PortBandwidthInMbps.Value);
            }
            if (Optional.IsDefined(UsedBandwidthInMbps))
            {
                writer.WritePropertyName("usedBandwidthInMbps"u8);
                writer.WriteNumberValue(UsedBandwidthInMbps.Value);
            }
            if (Optional.IsDefined(RemainingBandwidthInMbps))
            {
                writer.WritePropertyName("remainingBandwidthInMbps"u8);
                writer.WriteNumberValue(RemainingBandwidthInMbps.Value);
            }
            writer.WriteEndObject();
        }

        ExpressRouteProviderPortData IJsonModel<ExpressRouteProviderPortData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ExpressRouteProviderPortData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ExpressRouteProviderPortData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeExpressRouteProviderPortData(document.RootElement, options);
        }

        internal static ExpressRouteProviderPortData DeserializeExpressRouteProviderPortData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ETag? etag = default;
            IDictionary<string, string> tags = default;
            AzureLocation location = default;
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            string portPairDescriptor = default;
            string primaryAzurePort = default;
            string secondaryAzurePort = default;
            string peeringLocation = default;
            int? overprovisionFactor = default;
            int? portBandwidthInMbps = default;
            int? usedBandwidthInMbps = default;
            int? remainingBandwidthInMbps = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("etag"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    etag = new ETag(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("tags"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    tags = dictionary;
                    continue;
                }
                if (property.NameEquals("location"u8))
                {
                    location = new AzureLocation(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("portPairDescriptor"u8))
                        {
                            portPairDescriptor = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("primaryAzurePort"u8))
                        {
                            primaryAzurePort = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("secondaryAzurePort"u8))
                        {
                            secondaryAzurePort = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("peeringLocation"u8))
                        {
                            peeringLocation = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("overprovisionFactor"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            overprovisionFactor = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("portBandwidthInMbps"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            portBandwidthInMbps = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("usedBandwidthInMbps"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            usedBandwidthInMbps = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("remainingBandwidthInMbps"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            remainingBandwidthInMbps = property0.Value.GetInt32();
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ExpressRouteProviderPortData(
                id,
                name,
                type,
                systemData,
                tags ?? new ChangeTrackingDictionary<string, string>(),
                location,
                etag,
                portPairDescriptor,
                primaryAzurePort,
                secondaryAzurePort,
                peeringLocation,
                overprovisionFactor,
                portBandwidthInMbps,
                usedBandwidthInMbps,
                remainingBandwidthInMbps,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ExpressRouteProviderPortData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ExpressRouteProviderPortData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ExpressRouteProviderPortData)} does not support writing '{options.Format}' format.");
            }
        }

        ExpressRouteProviderPortData IPersistableModel<ExpressRouteProviderPortData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ExpressRouteProviderPortData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeExpressRouteProviderPortData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ExpressRouteProviderPortData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ExpressRouteProviderPortData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
