// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Network.Models;

namespace Azure.ResourceManager.Network
{
    /// <summary>
    /// A class representing the ExpressRoutePortsLocation data model.
    /// Definition of the ExpressRoutePorts peering location resource.
    /// </summary>
    public partial class ExpressRoutePortsLocationData : NetworkTrackedResourceData
    {
        /// <summary> Initializes a new instance of <see cref="ExpressRoutePortsLocationData"/>. </summary>
        public ExpressRoutePortsLocationData()
        {
            AvailableBandwidths = new ChangeTrackingList<ExpressRoutePortsLocationBandwidths>();
        }

        /// <summary> Initializes a new instance of <see cref="ExpressRoutePortsLocationData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="address"> Address of peering location. </param>
        /// <param name="contact"> Contact details of peering locations. </param>
        /// <param name="availableBandwidths"> The inventory of available ExpressRoutePort bandwidths. </param>
        /// <param name="provisioningState"> The provisioning state of the express route port location resource. </param>
        internal ExpressRoutePortsLocationData(ResourceIdentifier id, string name, ResourceType? resourceType, AzureLocation? location, IDictionary<string, string> tags, IDictionary<string, BinaryData> serializedAdditionalRawData, string address, string contact, IList<ExpressRoutePortsLocationBandwidths> availableBandwidths, NetworkProvisioningState? provisioningState) : base(id, name, resourceType, location, tags, serializedAdditionalRawData)
        {
            Address = address;
            Contact = contact;
            AvailableBandwidths = availableBandwidths;
            ProvisioningState = provisioningState;
        }

        /// <summary> Address of peering location. </summary>
        public string Address { get; }
        /// <summary> Contact details of peering locations. </summary>
        public string Contact { get; }
        /// <summary> The inventory of available ExpressRoutePort bandwidths. </summary>
        public IList<ExpressRoutePortsLocationBandwidths> AvailableBandwidths { get; }
        /// <summary> The provisioning state of the express route port location resource. </summary>
        public NetworkProvisioningState? ProvisioningState { get; }
    }
}
