// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Network.Models;

namespace Azure.ResourceManager.Network
{
    /// <summary>
    /// A class representing the ExpressRoutePortAuthorization data model.
    /// ExpressRoutePort Authorization resource definition.
    /// </summary>
    public partial class ExpressRoutePortAuthorizationData : NetworkResourceData
    {
        /// <summary> Initializes a new instance of <see cref="ExpressRoutePortAuthorizationData"/>. </summary>
        public ExpressRoutePortAuthorizationData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ExpressRoutePortAuthorizationData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="authorizationKey"> The authorization key. </param>
        /// <param name="authorizationUseStatus"> The authorization use status. </param>
        /// <param name="circuitResourceUri"> The reference to the ExpressRoute circuit resource using the authorization. </param>
        /// <param name="provisioningState"> The provisioning state of the authorization resource. </param>
        internal ExpressRoutePortAuthorizationData(ResourceIdentifier id, string name, ResourceType? resourceType, IDictionary<string, BinaryData> serializedAdditionalRawData, ETag? etag, string authorizationKey, ExpressRoutePortAuthorizationUseStatus? authorizationUseStatus, Uri circuitResourceUri, NetworkProvisioningState? provisioningState) : base(id, name, resourceType, serializedAdditionalRawData)
        {
            ETag = etag;
            AuthorizationKey = authorizationKey;
            AuthorizationUseStatus = authorizationUseStatus;
            CircuitResourceUri = circuitResourceUri;
            ProvisioningState = provisioningState;
        }

        /// <summary> A unique read-only string that changes whenever the resource is updated. </summary>
        public ETag? ETag { get; }
        /// <summary> The authorization key. </summary>
        public string AuthorizationKey { get; }
        /// <summary> The authorization use status. </summary>
        public ExpressRoutePortAuthorizationUseStatus? AuthorizationUseStatus { get; }
        /// <summary> The reference to the ExpressRoute circuit resource using the authorization. </summary>
        public Uri CircuitResourceUri { get; }
        /// <summary> The provisioning state of the authorization resource. </summary>
        public NetworkProvisioningState? ProvisioningState { get; }
    }
}
