// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Network.Models;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.Network
{
    /// <summary>
    /// A class representing the ExpressRouteCrossConnection data model.
    /// ExpressRouteCrossConnection resource.
    /// </summary>
    public partial class ExpressRouteCrossConnectionData : NetworkTrackedResourceData
    {
        /// <summary> Initializes a new instance of <see cref="ExpressRouteCrossConnectionData"/>. </summary>
        public ExpressRouteCrossConnectionData()
        {
            Peerings = new ChangeTrackingList<ExpressRouteCrossConnectionPeeringData>();
        }

        /// <summary> Initializes a new instance of <see cref="ExpressRouteCrossConnectionData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="primaryAzurePort"> The name of the primary port. </param>
        /// <param name="secondaryAzurePort"> The name of the secondary port. </param>
        /// <param name="stag"> The identifier of the circuit traffic. </param>
        /// <param name="peeringLocation"> The peering location of the ExpressRoute circuit. </param>
        /// <param name="bandwidthInMbps"> The circuit bandwidth In Mbps. </param>
        /// <param name="expressRouteCircuit"> The ExpressRouteCircuit. </param>
        /// <param name="serviceProviderProvisioningState"> The provisioning state of the circuit in the connectivity provider system. </param>
        /// <param name="serviceProviderNotes"> Additional read only notes set by the connectivity provider. </param>
        /// <param name="provisioningState"> The provisioning state of the express route cross connection resource. </param>
        /// <param name="peerings"> The list of peerings. </param>
        internal ExpressRouteCrossConnectionData(ResourceIdentifier id, string name, ResourceType? resourceType, AzureLocation? location, IDictionary<string, string> tags, IDictionary<string, BinaryData> serializedAdditionalRawData, ETag? etag, string primaryAzurePort, string secondaryAzurePort, int? stag, string peeringLocation, int? bandwidthInMbps, WritableSubResource expressRouteCircuit, ServiceProviderProvisioningState? serviceProviderProvisioningState, string serviceProviderNotes, NetworkProvisioningState? provisioningState, IList<ExpressRouteCrossConnectionPeeringData> peerings) : base(id, name, resourceType, location, tags, serializedAdditionalRawData)
        {
            ETag = etag;
            PrimaryAzurePort = primaryAzurePort;
            SecondaryAzurePort = secondaryAzurePort;
            STag = stag;
            PeeringLocation = peeringLocation;
            BandwidthInMbps = bandwidthInMbps;
            ExpressRouteCircuit = expressRouteCircuit;
            ServiceProviderProvisioningState = serviceProviderProvisioningState;
            ServiceProviderNotes = serviceProviderNotes;
            ProvisioningState = provisioningState;
            Peerings = peerings;
        }

        /// <summary> A unique read-only string that changes whenever the resource is updated. </summary>
        public ETag? ETag { get; }
        /// <summary> The name of the primary port. </summary>
        public string PrimaryAzurePort { get; }
        /// <summary> The name of the secondary port. </summary>
        public string SecondaryAzurePort { get; }
        /// <summary> The identifier of the circuit traffic. </summary>
        public int? STag { get; }
        /// <summary> The peering location of the ExpressRoute circuit. </summary>
        public string PeeringLocation { get; }
        /// <summary> The circuit bandwidth In Mbps. </summary>
        public int? BandwidthInMbps { get; }
        /// <summary> The ExpressRouteCircuit. </summary>
        internal WritableSubResource ExpressRouteCircuit { get; set; }
        /// <summary> Gets or sets Id. </summary>
        public ResourceIdentifier ExpressRouteCircuitId
        {
            get => ExpressRouteCircuit is null ? default : ExpressRouteCircuit.Id;
            set
            {
                if (ExpressRouteCircuit is null)
                    ExpressRouteCircuit = new WritableSubResource();
                ExpressRouteCircuit.Id = value;
            }
        }

        /// <summary> The provisioning state of the circuit in the connectivity provider system. </summary>
        public ServiceProviderProvisioningState? ServiceProviderProvisioningState { get; set; }
        /// <summary> Additional read only notes set by the connectivity provider. </summary>
        public string ServiceProviderNotes { get; set; }
        /// <summary> The provisioning state of the express route cross connection resource. </summary>
        public NetworkProvisioningState? ProvisioningState { get; }
        /// <summary> The list of peerings. </summary>
        public IList<ExpressRouteCrossConnectionPeeringData> Peerings { get; }
    }
}
