// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Network.Models;

namespace Azure.ResourceManager.Network
{
    /// <summary>
    /// A class representing the ExpressRouteCircuitAuthorization data model.
    /// Authorization in an ExpressRouteCircuit resource.
    /// </summary>
    public partial class ExpressRouteCircuitAuthorizationData : NetworkResourceData
    {
        /// <summary> Initializes a new instance of <see cref="ExpressRouteCircuitAuthorizationData"/>. </summary>
        public ExpressRouteCircuitAuthorizationData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ExpressRouteCircuitAuthorizationData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="authorizationKey"> The authorization key. </param>
        /// <param name="authorizationUseStatus"> The authorization use status. </param>
        /// <param name="connectionResourceUri"> The reference to the ExpressRoute connection resource using the authorization. </param>
        /// <param name="provisioningState"> The provisioning state of the authorization resource. </param>
        internal ExpressRouteCircuitAuthorizationData(ResourceIdentifier id, string name, ResourceType? resourceType, IDictionary<string, BinaryData> serializedAdditionalRawData, ETag? etag, string authorizationKey, AuthorizationUseStatus? authorizationUseStatus, Uri connectionResourceUri, NetworkProvisioningState? provisioningState) : base(id, name, resourceType, serializedAdditionalRawData)
        {
            ETag = etag;
            AuthorizationKey = authorizationKey;
            AuthorizationUseStatus = authorizationUseStatus;
            ConnectionResourceUri = connectionResourceUri;
            ProvisioningState = provisioningState;
        }

        /// <summary> A unique read-only string that changes whenever the resource is updated. </summary>
        public ETag? ETag { get; }
        /// <summary> The authorization key. </summary>
        public string AuthorizationKey { get; set; }
        /// <summary> The authorization use status. </summary>
        public AuthorizationUseStatus? AuthorizationUseStatus { get; set; }
        /// <summary> The reference to the ExpressRoute connection resource using the authorization. </summary>
        public Uri ConnectionResourceUri { get; }
        /// <summary> The provisioning state of the authorization resource. </summary>
        public NetworkProvisioningState? ProvisioningState { get; }
    }
}
