// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Network.Models;

namespace Azure.ResourceManager.Network
{
    public partial class DscpConfigurationData : IUtf8JsonSerializable, IJsonModel<DscpConfigurationData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<DscpConfigurationData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<DscpConfigurationData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DscpConfigurationData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DscpConfigurationData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (options.Format != "W" && Optional.IsDefined(ETag))
            {
                writer.WritePropertyName("etag"u8);
                writer.WriteStringValue(ETag.Value.ToString());
            }
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsCollectionDefined(Markings))
            {
                writer.WritePropertyName("markings"u8);
                writer.WriteStartArray();
                foreach (var item in Markings)
                {
                    writer.WriteNumberValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(SourceIPRanges))
            {
                writer.WritePropertyName("sourceIpRanges"u8);
                writer.WriteStartArray();
                foreach (var item in SourceIPRanges)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(DestinationIPRanges))
            {
                writer.WritePropertyName("destinationIpRanges"u8);
                writer.WriteStartArray();
                foreach (var item in DestinationIPRanges)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(SourcePortRanges))
            {
                writer.WritePropertyName("sourcePortRanges"u8);
                writer.WriteStartArray();
                foreach (var item in SourcePortRanges)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(DestinationPortRanges))
            {
                writer.WritePropertyName("destinationPortRanges"u8);
                writer.WriteStartArray();
                foreach (var item in DestinationPortRanges)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(Protocol))
            {
                writer.WritePropertyName("protocol"u8);
                writer.WriteStringValue(Protocol.Value.ToString());
            }
            if (Optional.IsCollectionDefined(QosDefinitionCollection))
            {
                writer.WritePropertyName("qosDefinitionCollection"u8);
                writer.WriteStartArray();
                foreach (var item in QosDefinitionCollection)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(QosCollectionId))
            {
                writer.WritePropertyName("qosCollectionId"u8);
                writer.WriteStringValue(QosCollectionId);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(AssociatedNetworkInterfaces))
            {
                writer.WritePropertyName("associatedNetworkInterfaces"u8);
                writer.WriteStartArray();
                foreach (var item in AssociatedNetworkInterfaces)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(ResourceGuid))
            {
                writer.WritePropertyName("resourceGuid"u8);
                writer.WriteStringValue(ResourceGuid.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            writer.WriteEndObject();
        }

        DscpConfigurationData IJsonModel<DscpConfigurationData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DscpConfigurationData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DscpConfigurationData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeDscpConfigurationData(document.RootElement, options);
        }

        internal static DscpConfigurationData DeserializeDscpConfigurationData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ETag? etag = default;
            ResourceIdentifier id = default;
            string name = default;
            ResourceType? type = default;
            AzureLocation? location = default;
            IDictionary<string, string> tags = default;
            IList<int> markings = default;
            IList<QosIPRange> sourceIPRanges = default;
            IList<QosIPRange> destinationIPRanges = default;
            IList<QosPortRange> sourcePortRanges = default;
            IList<QosPortRange> destinationPortRanges = default;
            ProtocolType? protocol = default;
            IList<DscpQosDefinition> qosDefinitionCollection = default;
            string qosCollectionId = default;
            IReadOnlyList<NetworkInterfaceData> associatedNetworkInterfaces = default;
            Guid? resourceGuid = default;
            NetworkProvisioningState? provisioningState = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("etag"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    etag = new ETag(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("id"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("location"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    location = new AzureLocation(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("tags"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    tags = dictionary;
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("markings"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<int> array = new List<int>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(item.GetInt32());
                            }
                            markings = array;
                            continue;
                        }
                        if (property0.NameEquals("sourceIpRanges"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<QosIPRange> array = new List<QosIPRange>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(QosIPRange.DeserializeQosIPRange(item, options));
                            }
                            sourceIPRanges = array;
                            continue;
                        }
                        if (property0.NameEquals("destinationIpRanges"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<QosIPRange> array = new List<QosIPRange>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(QosIPRange.DeserializeQosIPRange(item, options));
                            }
                            destinationIPRanges = array;
                            continue;
                        }
                        if (property0.NameEquals("sourcePortRanges"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<QosPortRange> array = new List<QosPortRange>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(QosPortRange.DeserializeQosPortRange(item, options));
                            }
                            sourcePortRanges = array;
                            continue;
                        }
                        if (property0.NameEquals("destinationPortRanges"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<QosPortRange> array = new List<QosPortRange>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(QosPortRange.DeserializeQosPortRange(item, options));
                            }
                            destinationPortRanges = array;
                            continue;
                        }
                        if (property0.NameEquals("protocol"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            protocol = new ProtocolType(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("qosDefinitionCollection"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<DscpQosDefinition> array = new List<DscpQosDefinition>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(DscpQosDefinition.DeserializeDscpQosDefinition(item, options));
                            }
                            qosDefinitionCollection = array;
                            continue;
                        }
                        if (property0.NameEquals("qosCollectionId"u8))
                        {
                            qosCollectionId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("associatedNetworkInterfaces"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<NetworkInterfaceData> array = new List<NetworkInterfaceData>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(NetworkInterfaceData.DeserializeNetworkInterfaceData(item, options));
                            }
                            associatedNetworkInterfaces = array;
                            continue;
                        }
                        if (property0.NameEquals("resourceGuid"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            resourceGuid = property0.Value.GetGuid();
                            continue;
                        }
                        if (property0.NameEquals("provisioningState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            provisioningState = new NetworkProvisioningState(property0.Value.GetString());
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new DscpConfigurationData(
                id,
                name,
                type,
                location,
                tags ?? new ChangeTrackingDictionary<string, string>(),
                serializedAdditionalRawData,
                etag,
                markings ?? new ChangeTrackingList<int>(),
                sourceIPRanges ?? new ChangeTrackingList<QosIPRange>(),
                destinationIPRanges ?? new ChangeTrackingList<QosIPRange>(),
                sourcePortRanges ?? new ChangeTrackingList<QosPortRange>(),
                destinationPortRanges ?? new ChangeTrackingList<QosPortRange>(),
                protocol,
                qosDefinitionCollection ?? new ChangeTrackingList<DscpQosDefinition>(),
                qosCollectionId,
                associatedNetworkInterfaces ?? new ChangeTrackingList<NetworkInterfaceData>(),
                resourceGuid,
                provisioningState);
        }

        BinaryData IPersistableModel<DscpConfigurationData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DscpConfigurationData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(DscpConfigurationData)} does not support writing '{options.Format}' format.");
            }
        }

        DscpConfigurationData IPersistableModel<DscpConfigurationData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DscpConfigurationData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeDscpConfigurationData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(DscpConfigurationData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<DscpConfigurationData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
