// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Network.Models;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.Network
{
    public partial class CustomIPPrefixData : IUtf8JsonSerializable, IJsonModel<CustomIPPrefixData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<CustomIPPrefixData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<CustomIPPrefixData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CustomIPPrefixData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CustomIPPrefixData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (Optional.IsDefined(ExtendedLocation))
            {
                writer.WritePropertyName("extendedLocation"u8);
                JsonSerializer.Serialize(writer, ExtendedLocation);
            }
            if (options.Format != "W" && Optional.IsDefined(ETag))
            {
                writer.WritePropertyName("etag"u8);
                writer.WriteStringValue(ETag.Value.ToString());
            }
            if (Optional.IsCollectionDefined(Zones))
            {
                writer.WritePropertyName("zones"u8);
                writer.WriteStartArray();
                foreach (var item in Zones)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(Asn))
            {
                writer.WritePropertyName("asn"u8);
                writer.WriteStringValue(Asn);
            }
            if (Optional.IsDefined(Cidr))
            {
                writer.WritePropertyName("cidr"u8);
                writer.WriteStringValue(Cidr);
            }
            if (Optional.IsDefined(SignedMessage))
            {
                writer.WritePropertyName("signedMessage"u8);
                writer.WriteStringValue(SignedMessage);
            }
            if (Optional.IsDefined(AuthorizationMessage))
            {
                writer.WritePropertyName("authorizationMessage"u8);
                writer.WriteStringValue(AuthorizationMessage);
            }
            if (Optional.IsDefined(ParentCustomIPPrefix))
            {
                writer.WritePropertyName("customIpPrefixParent"u8);
                JsonSerializer.Serialize(writer, ParentCustomIPPrefix);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(ChildCustomIPPrefixList))
            {
                writer.WritePropertyName("childCustomIpPrefixes"u8);
                writer.WriteStartArray();
                foreach (var item in ChildCustomIPPrefixList)
                {
                    JsonSerializer.Serialize(writer, item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(CommissionedState))
            {
                writer.WritePropertyName("commissionedState"u8);
                writer.WriteStringValue(CommissionedState.Value.ToString());
            }
            if (Optional.IsDefined(ExpressRouteAdvertise))
            {
                writer.WritePropertyName("expressRouteAdvertise"u8);
                writer.WriteBooleanValue(ExpressRouteAdvertise.Value);
            }
            if (Optional.IsDefined(Geo))
            {
                writer.WritePropertyName("geo"u8);
                writer.WriteStringValue(Geo.Value.ToString());
            }
            if (Optional.IsDefined(NoInternetAdvertise))
            {
                writer.WritePropertyName("noInternetAdvertise"u8);
                writer.WriteBooleanValue(NoInternetAdvertise.Value);
            }
            if (Optional.IsDefined(PrefixType))
            {
                writer.WritePropertyName("prefixType"u8);
                writer.WriteStringValue(PrefixType.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(PublicIPPrefixes))
            {
                writer.WritePropertyName("publicIpPrefixes"u8);
                writer.WriteStartArray();
                foreach (var item in PublicIPPrefixes)
                {
                    JsonSerializer.Serialize(writer, item);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(ResourceGuid))
            {
                writer.WritePropertyName("resourceGuid"u8);
                writer.WriteStringValue(ResourceGuid.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(FailedReason))
            {
                writer.WritePropertyName("failedReason"u8);
                writer.WriteStringValue(FailedReason);
            }
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            writer.WriteEndObject();
        }

        CustomIPPrefixData IJsonModel<CustomIPPrefixData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CustomIPPrefixData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CustomIPPrefixData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeCustomIPPrefixData(document.RootElement, options);
        }

        internal static CustomIPPrefixData DeserializeCustomIPPrefixData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ExtendedLocation extendedLocation = default;
            ETag? etag = default;
            IList<string> zones = default;
            ResourceIdentifier id = default;
            string name = default;
            ResourceType? type = default;
            AzureLocation? location = default;
            IDictionary<string, string> tags = default;
            string asn = default;
            string cidr = default;
            string signedMessage = default;
            string authorizationMessage = default;
            WritableSubResource customIPPrefixParent = default;
            IReadOnlyList<WritableSubResource> childCustomIPPrefixes = default;
            CommissionedState? commissionedState = default;
            bool? expressRouteAdvertise = default;
            CidrAdvertisingGeoCode? geo = default;
            bool? noInternetAdvertise = default;
            CustomIPPrefixType? prefixType = default;
            IReadOnlyList<WritableSubResource> publicIPPrefixes = default;
            Guid? resourceGuid = default;
            string failedReason = default;
            NetworkProvisioningState? provisioningState = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("extendedLocation"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    extendedLocation = JsonSerializer.Deserialize<ExtendedLocation>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("etag"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    etag = new ETag(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("zones"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    zones = array;
                    continue;
                }
                if (property.NameEquals("id"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("location"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    location = new AzureLocation(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("tags"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    tags = dictionary;
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("asn"u8))
                        {
                            asn = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("cidr"u8))
                        {
                            cidr = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("signedMessage"u8))
                        {
                            signedMessage = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("authorizationMessage"u8))
                        {
                            authorizationMessage = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("customIpPrefixParent"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            customIPPrefixParent = JsonSerializer.Deserialize<WritableSubResource>(property0.Value.GetRawText());
                            continue;
                        }
                        if (property0.NameEquals("childCustomIpPrefixes"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<WritableSubResource> array = new List<WritableSubResource>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(JsonSerializer.Deserialize<WritableSubResource>(item.GetRawText()));
                            }
                            childCustomIPPrefixes = array;
                            continue;
                        }
                        if (property0.NameEquals("commissionedState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            commissionedState = new CommissionedState(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("expressRouteAdvertise"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            expressRouteAdvertise = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("geo"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            geo = new CidrAdvertisingGeoCode(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("noInternetAdvertise"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            noInternetAdvertise = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("prefixType"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            prefixType = new CustomIPPrefixType(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("publicIpPrefixes"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<WritableSubResource> array = new List<WritableSubResource>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(JsonSerializer.Deserialize<WritableSubResource>(item.GetRawText()));
                            }
                            publicIPPrefixes = array;
                            continue;
                        }
                        if (property0.NameEquals("resourceGuid"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            resourceGuid = property0.Value.GetGuid();
                            continue;
                        }
                        if (property0.NameEquals("failedReason"u8))
                        {
                            failedReason = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("provisioningState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            provisioningState = new NetworkProvisioningState(property0.Value.GetString());
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new CustomIPPrefixData(
                id,
                name,
                type,
                location,
                tags ?? new ChangeTrackingDictionary<string, string>(),
                serializedAdditionalRawData,
                extendedLocation,
                etag,
                zones ?? new ChangeTrackingList<string>(),
                asn,
                cidr,
                signedMessage,
                authorizationMessage,
                customIPPrefixParent,
                childCustomIPPrefixes ?? new ChangeTrackingList<WritableSubResource>(),
                commissionedState,
                expressRouteAdvertise,
                geo,
                noInternetAdvertise,
                prefixType,
                publicIPPrefixes ?? new ChangeTrackingList<WritableSubResource>(),
                resourceGuid,
                failedReason,
                provisioningState);
        }

        BinaryData IPersistableModel<CustomIPPrefixData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CustomIPPrefixData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(CustomIPPrefixData)} does not support writing '{options.Format}' format.");
            }
        }

        CustomIPPrefixData IPersistableModel<CustomIPPrefixData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CustomIPPrefixData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeCustomIPPrefixData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(CustomIPPrefixData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<CustomIPPrefixData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
