// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Network.Models;

namespace Azure.ResourceManager.Network
{
    /// <summary>
    /// A class representing the ConnectivityConfiguration data model.
    /// The network manager connectivity configuration resource
    /// </summary>
    public partial class ConnectivityConfigurationData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ConnectivityConfigurationData"/>. </summary>
        public ConnectivityConfigurationData()
        {
            Hubs = new ChangeTrackingList<ConnectivityHub>();
            AppliesToGroups = new ChangeTrackingList<ConnectivityGroupItem>();
        }

        /// <summary> Initializes a new instance of <see cref="ConnectivityConfigurationData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="description"> A description of the connectivity configuration. </param>
        /// <param name="connectivityTopology"> Connectivity topology type. </param>
        /// <param name="hubs"> List of hubItems. </param>
        /// <param name="isGlobal"> Flag if global mesh is supported. </param>
        /// <param name="appliesToGroups"> Groups for configuration. </param>
        /// <param name="provisioningState"> The provisioning state of the connectivity configuration resource. </param>
        /// <param name="deleteExistingPeering"> Flag if need to remove current existing peerings. </param>
        /// <param name="resourceGuid"> Unique identifier for this resource. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ConnectivityConfigurationData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string description, ConnectivityTopology? connectivityTopology, IList<ConnectivityHub> hubs, GlobalMeshSupportFlag? isGlobal, IList<ConnectivityGroupItem> appliesToGroups, NetworkProvisioningState? provisioningState, DeleteExistingPeering? deleteExistingPeering, Guid? resourceGuid, ETag? etag, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            Description = description;
            ConnectivityTopology = connectivityTopology;
            Hubs = hubs;
            IsGlobal = isGlobal;
            AppliesToGroups = appliesToGroups;
            ProvisioningState = provisioningState;
            DeleteExistingPeering = deleteExistingPeering;
            ResourceGuid = resourceGuid;
            ETag = etag;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> A description of the connectivity configuration. </summary>
        public string Description { get; set; }
        /// <summary> Connectivity topology type. </summary>
        public ConnectivityTopology? ConnectivityTopology { get; set; }
        /// <summary> List of hubItems. </summary>
        public IList<ConnectivityHub> Hubs { get; }
        /// <summary> Flag if global mesh is supported. </summary>
        public GlobalMeshSupportFlag? IsGlobal { get; set; }
        /// <summary> Groups for configuration. </summary>
        public IList<ConnectivityGroupItem> AppliesToGroups { get; }
        /// <summary> The provisioning state of the connectivity configuration resource. </summary>
        public NetworkProvisioningState? ProvisioningState { get; }
        /// <summary> Flag if need to remove current existing peerings. </summary>
        public DeleteExistingPeering? DeleteExistingPeering { get; set; }
        /// <summary> Unique identifier for this resource. </summary>
        public Guid? ResourceGuid { get; }
        /// <summary> A unique read-only string that changes whenever the resource is updated. </summary>
        public ETag? ETag { get; }
    }
}
