// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Network.Models;

namespace Azure.ResourceManager.Network
{
    public partial class ConnectionMonitorData : IUtf8JsonSerializable, IJsonModel<ConnectionMonitorData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ConnectionMonitorData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ConnectionMonitorData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConnectionMonitorData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ConnectionMonitorData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (options.Format != "W" && Optional.IsDefined(ETag))
            {
                writer.WritePropertyName("etag"u8);
                writer.WriteStringValue(ETag.Value.ToString());
            }
            if (Optional.IsDefined(Location))
            {
                writer.WritePropertyName("location"u8);
                writer.WriteStringValue(Location.Value);
            }
            if (Optional.IsCollectionDefined(Tags))
            {
                writer.WritePropertyName("tags"u8);
                writer.WriteStartObject();
                foreach (var item in Tags)
                {
                    writer.WritePropertyName(item.Key);
                    writer.WriteStringValue(item.Value);
                }
                writer.WriteEndObject();
            }
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(Source))
            {
                writer.WritePropertyName("source"u8);
                writer.WriteObjectValue(Source, options);
            }
            if (Optional.IsDefined(Destination))
            {
                writer.WritePropertyName("destination"u8);
                writer.WriteObjectValue(Destination, options);
            }
            if (Optional.IsDefined(AutoStart))
            {
                writer.WritePropertyName("autoStart"u8);
                writer.WriteBooleanValue(AutoStart.Value);
            }
            if (Optional.IsDefined(MonitoringIntervalInSeconds))
            {
                writer.WritePropertyName("monitoringIntervalInSeconds"u8);
                writer.WriteNumberValue(MonitoringIntervalInSeconds.Value);
            }
            if (Optional.IsCollectionDefined(Endpoints))
            {
                writer.WritePropertyName("endpoints"u8);
                writer.WriteStartArray();
                foreach (var item in Endpoints)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(TestConfigurations))
            {
                writer.WritePropertyName("testConfigurations"u8);
                writer.WriteStartArray();
                foreach (var item in TestConfigurations)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(TestGroups))
            {
                writer.WritePropertyName("testGroups"u8);
                writer.WriteStartArray();
                foreach (var item in TestGroups)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Outputs))
            {
                writer.WritePropertyName("outputs"u8);
                writer.WriteStartArray();
                foreach (var item in Outputs)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(Notes))
            {
                writer.WritePropertyName("notes"u8);
                writer.WriteStringValue(Notes);
            }
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(StartOn))
            {
                writer.WritePropertyName("startTime"u8);
                writer.WriteStringValue(StartOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(MonitoringStatus))
            {
                writer.WritePropertyName("monitoringStatus"u8);
                writer.WriteStringValue(MonitoringStatus);
            }
            if (options.Format != "W" && Optional.IsDefined(ConnectionMonitorType))
            {
                writer.WritePropertyName("connectionMonitorType"u8);
                writer.WriteStringValue(ConnectionMonitorType.Value.ToString());
            }
            writer.WriteEndObject();
        }

        ConnectionMonitorData IJsonModel<ConnectionMonitorData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConnectionMonitorData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ConnectionMonitorData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeConnectionMonitorData(document.RootElement, options);
        }

        internal static ConnectionMonitorData DeserializeConnectionMonitorData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ETag? etag = default;
            AzureLocation? location = default;
            IReadOnlyDictionary<string, string> tags = default;
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            ConnectionMonitorSource source = default;
            ConnectionMonitorDestination destination = default;
            bool? autoStart = default;
            int? monitoringIntervalInSeconds = default;
            IReadOnlyList<ConnectionMonitorEndpoint> endpoints = default;
            IReadOnlyList<ConnectionMonitorTestConfiguration> testConfigurations = default;
            IReadOnlyList<ConnectionMonitorTestGroup> testGroups = default;
            IReadOnlyList<ConnectionMonitorOutput> outputs = default;
            string notes = default;
            NetworkProvisioningState? provisioningState = default;
            DateTimeOffset? startTime = default;
            string monitoringStatus = default;
            ConnectionMonitorType? connectionMonitorType = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("etag"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    etag = new ETag(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("location"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    location = new AzureLocation(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("tags"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    tags = dictionary;
                    continue;
                }
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("source"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            source = ConnectionMonitorSource.DeserializeConnectionMonitorSource(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("destination"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            destination = ConnectionMonitorDestination.DeserializeConnectionMonitorDestination(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("autoStart"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            autoStart = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("monitoringIntervalInSeconds"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            monitoringIntervalInSeconds = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("endpoints"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<ConnectionMonitorEndpoint> array = new List<ConnectionMonitorEndpoint>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(ConnectionMonitorEndpoint.DeserializeConnectionMonitorEndpoint(item, options));
                            }
                            endpoints = array;
                            continue;
                        }
                        if (property0.NameEquals("testConfigurations"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<ConnectionMonitorTestConfiguration> array = new List<ConnectionMonitorTestConfiguration>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(ConnectionMonitorTestConfiguration.DeserializeConnectionMonitorTestConfiguration(item, options));
                            }
                            testConfigurations = array;
                            continue;
                        }
                        if (property0.NameEquals("testGroups"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<ConnectionMonitorTestGroup> array = new List<ConnectionMonitorTestGroup>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(ConnectionMonitorTestGroup.DeserializeConnectionMonitorTestGroup(item, options));
                            }
                            testGroups = array;
                            continue;
                        }
                        if (property0.NameEquals("outputs"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<ConnectionMonitorOutput> array = new List<ConnectionMonitorOutput>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(ConnectionMonitorOutput.DeserializeConnectionMonitorOutput(item, options));
                            }
                            outputs = array;
                            continue;
                        }
                        if (property0.NameEquals("notes"u8))
                        {
                            notes = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("provisioningState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            provisioningState = new NetworkProvisioningState(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("startTime"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            startTime = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("monitoringStatus"u8))
                        {
                            monitoringStatus = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("connectionMonitorType"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            connectionMonitorType = new ConnectionMonitorType(property0.Value.GetString());
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ConnectionMonitorData(
                id,
                name,
                type,
                systemData,
                etag,
                location,
                tags ?? new ChangeTrackingDictionary<string, string>(),
                source,
                destination,
                autoStart,
                monitoringIntervalInSeconds,
                endpoints ?? new ChangeTrackingList<ConnectionMonitorEndpoint>(),
                testConfigurations ?? new ChangeTrackingList<ConnectionMonitorTestConfiguration>(),
                testGroups ?? new ChangeTrackingList<ConnectionMonitorTestGroup>(),
                outputs ?? new ChangeTrackingList<ConnectionMonitorOutput>(),
                notes,
                provisioningState,
                startTime,
                monitoringStatus,
                connectionMonitorType,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ConnectionMonitorData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConnectionMonitorData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ConnectionMonitorData)} does not support writing '{options.Format}' format.");
            }
        }

        ConnectionMonitorData IPersistableModel<ConnectionMonitorData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConnectionMonitorData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeConnectionMonitorData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ConnectionMonitorData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ConnectionMonitorData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
